/* #include <stdio.h> */
/* #include <math.h> */
/* #include <sys/time.h> */

#define NMAX 2000

#define A_SIZE NMAX
#define B_SIZE NMAX
static double A[A_SIZE][A_SIZE];
static double B[B_SIZE][B_SIZE];
static double C[B_SIZE][B_SIZE];

int printf(const char*, ...);

void tmm(long Ni, long Nj, long Nk) {
	int i, j, k;
	
#pragma scop
	for(i = 0; i < Ni; i++) {
		for(j=i; j < Nj; j++) { 
			for(k=i;  k< Nk; k++) {
				C[i][j] += A[i][k] * B[k][j];
			}
		}
	}
#pragma endscop

}

int main(int argc, char **argv)
{
  double t_start, t_end;
	long N=NMAX;

	int i, j, k;

	for (i = 0; i < NMAX; i++) {
		for (j = 0; j < NMAX; j++) {
			C[i][j] = 0.0;
			A[i][j] = B[i][j] = (i+j)/2.0;
		}
	}


	tmm(N,N,N);

    for (i = 0; i < NMAX; i++) {
      for (j = 0; j < NMAX; j++) {
        printf("%lf ", C[i][j]);
      }
    }

  return 0;
}
