#!/bin/sh
#
#                    The PACE Application Aware Partitioner
#
# Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
#
# The information and source code contained herein is the exclusive property
# of ET International, Inc. and may not be disclosed, examined or reproduced
# in whole or in part without explicit written authorization from the company.
#
# This software was produced under a U.S. Government contract with the Air
# Force Research Lab. The U.S. Government is licensed to use, reproduce,
# modify, and distribute this software for use within the U.S. Government.
# These rights are equivalent to:
# GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
#

# get the actual path to the executable
BASE=$1
INPUT=${BASE}/test/arraypadding/input/
AAP=${BASE}/AAP

# The first argument should be an array padding description, which defines the
# variables ARRAYS (a comma separated list of arrays that should be padded) and
# FILES (a comma separated list of files to use as input). The values in FILES
# may refer to the PAD_INPUT variable.
. $2;

echo "$AAP --pad-arrays --safe-arrays=$ARRAYS -test-files=$FILES"
$AAP --pad-arrays --safe-arrays=${ARRAYS} -test-files=${FILES}

# sysexits.h has EX__BASE at 64. Anything above that is a hard error.
status=$?
if test $status -gt 63; then
    exit 99;                    # Automake treats 99 as a "hard" fail.
else
    exit $status;
fi
