#!/bin/bash
#
#                    The PACE Application Aware Partitioner
#
# Copyright (C) 2010, ET International, Inc. All rights reserved.
#
# The information and source code contained herein is the exclusive property
# of ET International, Inc. and may not be disclosed, examined or reproduced
# in whole or in part without explicit written authorization from the company.
#
# This software was produced under a U.S. Government contract with the Air
# Force Research Lab. The U.S. Government is licensed to use, reproduce,
# modify, and distribute this software for use within the U.S. Government.
# These rights are equivalent to:
# GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915


# Generate a set of test identifiers for the AAP to partition, compile, and
# check the translator's suite of C input files.
#
# The first command line argument should be a directory of .c files, from which
# a series of other identifiers will be created (the remaining arguments).
#
#	./buildTranslatorTests.sh $< $@ ${TRANSLATOR_EXTENTIONS}
# $1 is the  target (output) file
# $2 is the  source directory
# $3 ... are the other extensions to generate

if [ $# -lt 2 ] ; then
    echo "usage $0 <output> <source dir>"
    exit 1;
fi

OUT=$1
SRC=$2

RPUDIR=RPU                      # directory for RPU test logs
LNDIR=LineCount                 # directory for line count test logs

touch ${OUT}
test -d ${SRC} || exit

C_FILES=$(ls ${SRC}/*.c)

mkdir -p ${RPUDIR}
mkdir -p ${LNDIR}

rm -f ${OUT}

for file in ${C_FILES}; do
    NONCFILE=${file%.c}
    BASEFILE=$(basename ${NONCFILE})
    RPUFILE="${RPUDIR}/${BASEFILE%.c}.rpu" # rpu creation test
    LNTEST="${LNDIR}/${BASEFILE%.c}.ln"    # line number test
    echo "TESTS+=${RPUFILE}" >> ${OUT}
    echo -e "${RPUFILE}: ${OUT} ${file}\n\techo ${file} > \$@" >> ${OUT}
    echo "TESTS+=${LNTEST}" >> ${OUT}
    echo -e "${LNTEST}: ${OUT} ${RPUFILE}\n\techo /tmp/${RPUFILE}/ > \$@" >> ${OUT}
    echo "${LNTEST%.ln}.log: ${RPUFILE%.rpu}.log" >> ${OUT}
done
