#!/usr/bin/awk -f

# Verifies that preprocessed C source has preprocessor line numbering that
# matches the actual file line numbers. The usage requires that an explicit
# file name be given, and not pipe redirection, so the lines that indicate
# return to the file are identifiable. Shell globs are fine.

# Lines beginning with a hash, space, number, and filename (in quotes) are
# preprocessor line directives. The number indicates the line of the file,
# which should match the current line number if the filename matches the input
# file name.

/^# / {
    # Checking the file name on each matching line is pretty inefficient, but
    # it's important to check each file name, and the FILENAME value doesn't
    # exist in the BEGIN block.
    if (FILENAME == "-") {
        print "invalid redirection: file name required";
        exit 1;
    }


    if ($3 == "\"" FILENAME "\"") {
        if (FNR != $2) {        # If the record number != the line number:
            print ARGV[1] ": line number mismatch in " FILENAME " line " FNR;
            print $0;           #
            Status = 1;         # Record a non-zero exit status.
            nextfile;           # Skip to the next file.
        }
    }
}

BEGIN {
    Status = 0;
}

END {
    exit Status;
}
