#!/bin/bash
#
#                    The PACE Application Aware Partitioner
#
# Copyright (C) 2010, ET International, Inc. All rights reserved.
#
# The information and source code contained herein is the exclusive property
# of ET International, Inc. and may not be disclosed, examined or reproduced
# in whole or in part without explicit written authorization from the company.
#
# This software was produced under a U.S. Government contract with the Air
# Force Research Lab. The U.S. Government is licensed to use, reproduce,
# modify, and distribute this software for use within the U.S. Government.
# These rights are equivalent to:
# GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915


# Takes a file containing the names of c files or directories containing c
# files and runs the lineNumberTest on all of the files found therein.

FAIL=0
echo using $1
for line in $(cat $1); do
    if [ -d $line ]; then files=$(ls $line/*.c); else files=$line; fi

    for file in $(ls $files); do
        echo -n "testing $file ... "
        if [ -f $file ]; then
            ./lineNumberTest.awk $file;
            if [ $? -gt 0 ]; then
                echo failed;
                FAIL=1;
            else
                echo passed;
            fi
        else
            echo not found;
            FAIL=2;
        fi
    done
done

exit ${FAIL}
