//===------------------------------------------------------------*- C++ -*-===//
//
//                    The PACE Application Aware Partitioner
//
// Copyright (C) 2009 - 2010, ET International, Inc. All rights reserved.
//
// The information and source code contained herein is the exclusive property
// of ET International, Inc. and may not be disclosed, examined or reproduced
// in whole or in part without explicit written authorization from the company.
//
// This software was produced under a U.S. Government contract with the Air
// Force Research Lab. The U.S. Government is licensed to use, reproduce,
// modify, and distribute this software for use within the U.S. Government.
// These rights are equivalent to:
// GOVERNMENT PURPOSE RIGHTS, CONTRACT: F33615-09-C-7915
//
//===----------------------------------------------------------------------===//

#ifndef AAP_UTILS_CALLCONVERTER_H
#define AAP_UTILS_CALLCONVERTER_H

#include <string>

namespace CallConverter 
{
    // Returns the position of the close parenthesis in the given string that
    // matches the open parenthesis at the given position in the string.
    size_t findParenMatch (std::string& data, size_t start);

    // Convert a string containing a function declaration to a call to same
    void convertDeclToCall (std::string&);

    // Returns the name of a parameter from the given parameter declaration.
    // For input like "long int *foo[8]" the output will be "foo"
    std::string extractParamName (const std::string& param);
}

#endif
