#include <unistd.h>
#include <stdio.h>

/* Niladic function that uses the POSIX call "sysconf" to 
 * discover the size of an operating system page.
 *
 * The TLB must support the same size page, or else we have
 * a truly odd implementation that ignores the hardware 
 * speedup afforded by the TLB.
 *
 * This call should work on any POSIX system.  If it fails, 
 * the code will whine and assume 4 kb pages.
 *
 */

int GetOSPageSize()
{
  long result;

  result = sysconf( _SC_PAGESIZE );

  if (result < 0)  /* Some systems support a variant spelling */
  {                /* check that one, if first fails          */
    result = 4096;
    fprintf(stderr,"Posix syscontrol fails to return page size.\n");
    fprintf(stderr,"Assuming common value of 4096 b.\n");
  }

  return (int) result;
}
