#include "BlackJackTimer.h"

#include "../Lib/pace_rc_memlib.h"

/* TimePerm
 *
 * Runs a permutation and returns elapsed time
 *
 * PARAMETERS: NAccesses
 *
 * RETURNS:    Elapsed time, in microseconds, as a double
 *
 */

void **GlobalTrashCan;

double TimePermPtr( void ** MemArray,      /* contains a permutation */
		    int StartPoint,        /* first word in permutation */
		    struct AccessCount NA  /* number of iterations */ )
{
  ticks start, finish;
  int   loads, iterations;
  void **p;

  if (NA.outer < 1)
  {
    fprintf(stderr,"In TimePerm(), Access count makes no sense");
    fprintf(stderr," ( %s ; %s )\n",
	    PrintNum(NA.outer), PrintNum(NA.inner));
    Abort("TimePerm() asked to execute zero iterations.\n",-1);
  }

  iterations = NA.outer;

  if ((NA.inner % 10) != 0)
  {
    fprintf(stderr,
	    "TimePerm: Number of iterations (%s)  is not divisible by 10.\n",
	    PrintNum(NA.inner));
  }

  /* start the timer */
  start = getticks();

  while (iterations > 0)
  {
    loads = NA.inner;
    p = MemArray[StartPoint];

    while (loads > 0)   /* unrolled by ten to reduce loop overhead */
    {
      p = *p;
      p = *p;
      p = *p;
      p = *p;
      p = *p;
      p = *p;
      p = *p;
      p = *p;
      p = *p;
      p = *p;
      loads -= 10;
    }
    iterations--;
  }
  finish = getticks();

  GlobalTrashCan = p;

  return elapsed(finish,start);
}
