/* PACE Project, Rice University
 *
 * Utility routines used in the cache-size tests. 
 *
 */

#include "pace_rc_memlib.h"

/* Ugly (but portable) routine to insert commas as 
 * separators into an integer.
 */
static int bufcount = 0;
static char buf[8][32];
static char errbuf[128];

char* PrintDNum( double num )
{
  char *p, *q, *r, b1[32];
  int i, j, digits, commas, decimals, point, length;

  if (bufcount >= 8)
    bufcount = 0;

  sprintf(b1,"%.12f",num);

  p = b1;
  digits = 0;

  /* First, discover how the number lays out */
  while ( 1 )  /* compute number of digits to left of decimal */
  {
    if (*p == '\0' || *p == '.')
      break;

    p++;
    digits++;
  }

  /*  compute number of commas */
  if (digits < 3)
    commas = 0;
  else 
  {
    commas = digits / 3;
    if (digits % 3 == 0)
      commas --;
  }

  decimals = 0;  /* Next, the number of digits to the right of the decimal */
  if (*p == '.')
  {
    point = 1;
    *p++;
    while ( 1 )
    {
      if (*p == '\0')
	break;
      p++;
      decimals++;
    }  
  }
  else
  {
    decimals = 0;
    point = 0;
  }

  length = digits+commas+point+decimals+1;

  /* Next, copy the string into the output buffer, inserting  commas */  
  q = &buf[bufcount][0] + length - 1;
  p = b1 + digits + point + decimals - 1;

  *q-- = '\0'; /* terminate q */

  for (i=0;i<decimals;i++) /* digits to the right of the decimal */
  {
    *q-- = *p--;
  }

  if (decimals > 0)  /* the decimal, if one exists */
  {
    *q-- = *p--;
  }

  for (i=1;i<=digits;i++)  /* digits and commas to the left of the decimal */
  {
    *q-- = *p--;
    if ((i < digits) && (i%3 == 0))
    {
      *q-- = ',';
      j = 0;
    }
  }

  /* Now, eliminate trailing zeros */
  q = &buf[bufcount][0] + length - 2;
  while (*q == '0')
  {
    *q = '\0'; /* replace trailing zero with a terminator */
    q--;
  }
  if (*q == '.')  /* nothing to right of decimal -> no decimal */
    *q = '\0';

  return &buf[bufcount++][0];
}

char* PrintNum( int num )
{
  return PrintDNum( (double) num );
}

/* Simple (and portable) routine to compute integer exponents
 */
int power( int base, int exponent)
{
  int ans = 1;

  while(exponent-- > 0)
  {
    ans = ans * base;
  }
  return ans;
}


/* Simple integer max function -- returns the larger of its arguments */

int Max( int i, int j)
{
  int result;

  if (i < j)
    result = j;
  else 
    result = i;

  return result;
}

/* Simple double max function -- returns the larger of its arguments */
double DMax( double d, double e)
{
  double result;

  if (d < e)
    result = e;
  else 
    result = d;

  return result;
}

/* Simple integer abs function -- returns positive magnitude of its argument */

int Abs( int i )
{
  int result;

  if (i < 0)
    result = -i;
  else
    result = i;

  return result;
}

/* Simple double abs function -- returns positive magnitude of its argument */
double DAbs( double d )
{
  double result;

  if (d < 0)
    result = -d;
  else
    result = d;

  return result;
}

/* Simple integer min function */

int Min( int i, int j )
{
  int result;

  if (i < j)
    result = i;
  else 
    result = j;

  return result;
}

/* Simple double min function */

double DMin( double d, double e )
{
  double result;

  if (d < e)
    result = d;
  else 
    result = e;

  return result;
}

/* Flush() -- clear the memory hierarchy
 *
 */

#define FLUSHBOUND 12 * 1024 * 1024  /* words */
static int FlushArray[FLUSHBOUND];
static int Warn = 1;

int UnitSize;  /* set by every memtest */

void Flush( int size )
{
  int i;

  size = (size * UnitSize) / sizeof(int);

  if (size > FLUSHBOUND)
  {
    if (Warn)
    {
      fprintf(LogFile,"\nFlush() requests array larger than 48 MB.");
      fprintf(LogFile,"  -> further warnings suppressed.\n");
      Warn = 0;
    }
    size = FLUSHBOUND;
  }

  for (i=0;i<size;i++)
    FlushArray[i] = i;

  GlobalTrash = FlushArray[ rand() % size ];
}
