/* 
 * The PACE Project, Rice University
 * 
 * Include file for the library of utilities used in the memory 
 * characterization microbenchmarks.
 *
 */
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#define log2(x) ((int) (log((double) x)/log(2.0)))

FILE *LogFile;
int  GlobalTrash;

struct IntList  {
  struct IntList *Next;
  int            Val;
};

struct AccessCount {
  int outer;
  int inner;
};

/* Routines from TimePerm.c */
double TimePerm( int A[], int sp,  struct AccessCount na );

double TimePermPtr( void ** M, int sp, struct AccessCount na );

/* Routines from Tests.c */
int SharpRiseTest( int Sizes[], 
		   double Times[], 
		   int Count, 
		   double Sensitivity );

struct IntList *InflectionTest( int Sizes[], 
				double Times[], 
				int Count, 
				int Unit );

struct IntList *LogInflectionTest( 
		      int    X[],         /* Data on the X axis */
		      double Y[],         /* Function values for X[i] */
		      int Count,          /* Number of data points */
		      int (*Confirm)(int s) );

/* Entry to the integer analysis package */
void IntAnalyze( int s[], int c[], int ct, char *filename, int sf,
                 int confirm( int sz ) );

/* Routines From Utils.c */

char *PrintNum( int n );
char *PrintDNum( double d );
int  power( int b, int e );
int  Max( int i, int j);
double DMax( double d, double e);
int Abs ( int i );
double DAbs( double d );
int Min( int i, int j );
void Flush( int s );           /* flushes memory with an array of size s */
void WriteResult( char *n, int v );  /* writes 'v' into '$PACE_RCDB'/'n' */
void DWriteResult( char *n, double v );  /* writes 'v' into '$PACE_RCDB'/'n' */
int ReadResult( char *n );
int ReadResultSoft( char *n );
double DReadResult( char *n );
double DReadResultSoft( char *n );
int GetL1Size();
int GetOSPageSize();
double GetAddCost();
void *PACE_AllocMem( int s );
void PACE_FreeMem( void *p );
int  PACE_AllocationCheck();
