/* PACE Project, Rice University
 *
 * This code measures the parameters of the cache memory system.
 * 
 * First, it determines L1 size, associativity, and line size.
 * It uses size to determine associativity.
 *
 *
 */

#include "MemTest.h"
#include "BlackJackTimer.h"

void exit( int x );
double sqrt(double x);
int errno;

char * TimeStamp();
int GetOSPageSize();
char HostName[128];

static int    GapSizes[MAX_TESTS_PER_RUN];
static int    Cycles[MAX_TESTS_PER_RUN];
static double Times[MAX_TESTS_PER_RUN];

static void DieWithMessage(char *currArg, int argNumber)
{
  fprintf(stderr,"Did not understand argument '%s' (%d).\n",
	  currArg,argNumber);
  fprintf(stderr,"Valid arguments are:\n");
  fprintf(stderr,"\t-g \tActivate internal debugging checks.\n");
  fprintf(stderr,"\t-l <name> \tUse <name> for log file.\n");
  fprintf(stderr,"\t-p \tDon't precondition the data.\n");
  fprintf(stderr,"\t-v \tPrint results (& debug info) incrementally.\n");
  exit(-1);  
}

int main(int argc, char *argv[])
{
  int i, j, arg, argNumber;
  char *currArg, *LogFileName;

  int    Count;

  Verbose   = 0;
  Debug     = 0;
  HeartBeat = 1;

  LogFileName = "./Log";

  /* Parse the command line parameters */
  for (argNumber = 1; argNumber < argc; argNumber++)
  {
    currArg = argv[argNumber];

    if (*currArg == '-')
    {
      currArg++; 
      while (*currArg != '\0')
      {
	switch(*currArg)
        {
	  case 'd':
	    Debug++;
	    break;
	  case 'g':
	    Debug++;
	    break;
  	  case 'h':
	    HeartBeat++;
	    break;
	  case 'l':
	    argNumber++;
	    LogFileName = argv[argNumber];
	    break;
	  case 'v':
            Verbose++;
	    break;
	  default:
	    DieWithMessage(currArg,argNumber);
	}
	currArg++;
      }
    }
  }

  /* Set up the Log File */
  fprintf(stderr,"Log File Name is '%s'.\n",LogFileName);

  LogFile = fopen(LogFileName,"w");
  if (LogFile == NULL) /* cannot use abort() since it writes 'LogFile' */
  {
    fprintf(stderr,"fopen() of 'CacheTestLog' failed\n");
    exit(-2);
  }

  (void) SetupAndMark( LogFile, "LogFile");
  fprintf(LogFile,"\"New Gap Test, Integer Analysis\"\n");

  /* test for the presence of the environment variable for temp results */
  (void) TestEnvVar();  /* dies if environment variable is missing */

  /* Some initializations */
  UnitSize   = sizeof(void *);           /* tests use a C 'void *' */
  fprintf(stderr,"\nUnitSize is %d.\n",UnitSize);
  fprintf(LogFile,"\"UnitSize is %d, run without prior L1 information.\"\n",
	  UnitSize);

  if (HeartBeat)
    fprintf(stderr,"Providing HeartBeat @ Level %d.\n",HeartBeat);

  /* Find an appropriate timer interval to allow 0.5% accuracy */
  TimerTick = FindTimerTick();
  MinTime = MIN_TICKS * TimerTick;

  fprintf(LogFile,"\"Timer tick is %s, Minimum time is %s\"\n",
	  PrintDNum(TimerTick), PrintDNum(MinTime));

  /* Initializations */
  BigInt = FindBigInt();
  i = (int) fmod(getticks(),1000000.0);
  fprintf(stderr,"Random seed is %s.\n",PrintNum(i));
  srand( i ); /* no real reason to believe in a better seed */

  AddCostInNsecs = GetAddCost();

  int FullRun = 1;
  if (FullRun)     
  {
    NATrials();
  }

  i = PACE_AllocationCheck();
  if (i != 0)
    fprintf(stderr,"Memory leak claimed %d aligned items.\n",i);
}
