/* Version set up for an array of void *'s */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <errno.h>
#include "../Lib/pace_rc_memlib.h"

#define TESTNAME "CacheL"
#define TESTSUFFIX "b"

#define MIN_TICKS   1000
#define TRIALS_FOR_MIN  50
#define LOWERBOUNDINWORDS  512
#define UPPERBOUNDINWORDS  4*1024*1024
#define MAX_TESTS_PER_RUN  1024
#define MAX_LEVELS  50

#define CorDThreshold  1.5

#define log2(x) ((int) (log((double) x)/log(2.0)))

FILE *LogFile,  *DataFile;

/* Control flags */
int Verbose;        /* controls level of comments in LogFile */
int HeartBeat;      /* controls level of heart beats to stderr */
int Data;           /* controls generation of CSV data file */
int Debug;          /* controls level of debugging detail (to stderr) */

/* Shared Global Data items ... initialized in main() */
int    UnitSize;    /* size of an void *, since tests work on void * */
double TimerTick;   /* Timer resolution, expressed as a double    */
double MinTime;     /* Minimum time for any test */
int    BigInt;      /* a very large integer */

int    GlobalTrash;  /* to defeat dead code elimination */

int    L1Size;       /* read from prior runs */
int    L1LineSize;
int    PageSize;     /* read from sysconf() */

double AddCostInNsecs;

/* Prototypes for functions */ 

double  FindTimerTick();
int     FindBigInt();

void   FindNA( int size, int blocksize, int stride, struct AccessCount *NA );
double  BCTest( int size, int blocksize, int stride, struct AccessCount NA );

/* Prototype for functions from math library */
double fmax(double x, double y);
double log(double x);



