/* This version modified to use 'int *' */
#include "MemTest.h"
#include "BlackJackTimer.h"


/* declaration of intrinsic */
double round ( double x );

struct AccessCount NAccesses;

/* Arrays for the Analysis */
#define MAX_ASSOC   33
static int GapSizes[MAX_ASSOC];
static int Spots   [MAX_ASSOC];
static int Cycles  [MAX_ASSOC];
static int Pattern [MAX_ASSOC];
static double Times[MAX_ASSOC];
static int StartingPoint     = -1;
static void **MemArray = (void *) NULL;

static int firsttime = 0;

static int AlwaysConfirm( int s )
{
  return 1;
}

/* for use when ArraySize is small relative to BlockSize */
static void BuildRefString( int NSpots, int Gap )
{
  int i, j, ThisElt, LastElt;
  int Index[NSpots];
  void **p, **Old;

  for (i=0;i<NSpots;i++)
  {
    Index[i] = i * Gap;
  }

  if (firsttime)
  {
    fprintf(stderr,"\nIndex set:\n");
    j = 0;
    for (i=0;i<NSpots;i++)
    {
      fprintf(stderr,"%12s ",PrintNum(Index[i]*UnitSize));
      j++;
      if (j == 4)
      {
	fprintf(stderr,"\n");
	j=0;
      }
    }
    fprintf(stderr,"\n\n");
    firsttime--;
  }

  Old = MemArray;
  MemArray = (void **) PACE_AllocMem((NSpots+1)*Gap*UnitSize);
  if (Old != (void **) NULL)
    PACE_FreeMem(Old);

  /* Assemble the permutation ...
   *
   * This case is a degenerate of the more complex, multipage case
   * done below.
   *
   */

  LastElt = -1;
  for (i=0; i<NSpots; i++)
  {
    ThisElt = Index[i];
    if (LastElt != -1)
      MemArray[ThisElt] = &MemArray[LastElt];
    if (Debug>1)
      fprintf(LogFile,"M[%s] <- %s.\n",PrintNum(ThisElt),PrintNum(LastElt));

    LastElt = ThisElt;
  }
  StartingPoint = Index[0];
  MemArray[StartingPoint] = &MemArray[LastElt];

  if (Debug>1)
    fprintf(LogFile,"M[%s] <- %s ** starting point**.\n",
	    PrintNum(StartingPoint),PrintNum(LastElt));

  /* verify permutation */
  p = MemArray[StartingPoint];   
  i = 0;
  while( p != &MemArray[StartingPoint] )
  {
    p = *p;
    i++;
    if (i > NSpots)
    {
      fprintf(stderr,"Cycle did not return to starting point.\n");
      fprintf(stderr,"Cycle length is %s of %s.\n",
	      PrintNum(i),PrintNum(NSpots));
    }
  }
  if (Debug>1)
  {
    if (i == (NSpots-1))
      fprintf(stderr,"Maximal length cycle.\n");
    else 
      fprintf(stderr,"%s vs %s.\n",PrintNum(i),PrintNum(NSpots));
  }


}

/* RunOneTest 
 *
 * RETURNS:     An elapsed time, in microseconds, as a double
 *
 */

double RunOneTest( int NSpots, int Gap )
{
  int i;
  double result;
  
  if (HeartBeat > 1)
    fprintf(stderr,"Trial of %d spots with %s b gap (%s b total size)\n",
	    NSpots,PrintNum(Gap*UnitSize),PrintNum(NSpots*Gap*UnitSize));

  /* Initialize MemArray */
  BuildRefString(NSpots,Gap);

  /* Run the test */
   result = TimePermPtr(MemArray, StartingPoint, NAccesses);

  if (HeartBeat > 1)
    fprintf(stderr,"%s usec\n",PrintDNum(result));

  return result;
}



/* NATrials:  Runs a complete set of trials
 *
 */

void NATrials()
{
  int i, j, k, NotDone, series, MoreTests, nPoints;
  int NSpots, LevelSize, NGaps, Increment;

  int Counters[MAX_TESTS_PER_RUN];
  int BlockSize, Stride;
  double Trial;

  int FirstTime = 1;

  fprintf(stderr,"In NATrials.\n");

  NAccesses.inner = 1000;
  NAccesses.outer = 1;
  Trial = 0;

  while(Trial < MinTime)
  {
    if (NAccesses.inner < BigInt)
      NAccesses.inner = NAccesses.inner + NAccesses.inner;
    else
      NAccesses.outer = NAccesses.outer + 1;

    Trial = RunOneTest( 2, 2048 );  /* 2 spots at 2 KB */
  }
  fprintf(LogFile,"Need to run (%s : %s) accesses to achieve > %s usec.\n",
	  PrintNum(NAccesses.outer),PrintNum(NAccesses.inner),
	  PrintNum(MinTime));

  LevelSize = 1024 / UnitSize;
  Increment = LevelSize;
  MoreTests = 1;
  nPoints = 0;

  while( MoreTests )
  {
    fprintf(stderr,"Testing @ %s b.\n",PrintNum(LevelSize*UnitSize));

    NotDone = 1;
    NGaps = 0; 
    NSpots = 2;
    while(NotDone)
    {
      GapSizes[NGaps]  = LevelSize / (NSpots - 1);
      Spots[NGaps]    = NSpots;
      Counters[NGaps] = TRIALS_FOR_MIN; 
      Times[NGaps++]  = -1.0;

      if (NSpots == 2)      /* generate series 2, 3, 5, 7, ..., 33 */
	NSpots = 3;
      else if (NSpots < 33)
	NSpots += 2;
      else
	NotDone = 0;
    } 

    NotDone = 1;
    series = 1;
    while(NotDone)
    {
      if (HeartBeat>1)
	fprintf(stderr,"NA Test, series %3d.",series++);

      NotDone = 0;
      j = 0;
      for (i=0;i<NGaps;i++)
      {
	if (Counters[i])
	{
	  j++;
	  
	  Trial = RunOneTest(Spots[i], GapSizes[i]);
	  Counters[i]--;

	  if (Times[i] == -1.0)
	    Times[i] = Trial;
	  else if (Trial < Times[i])
	  {
	    Times[i] = Trial;
	    Counters[i] = TRIALS_FOR_MIN;
	  }
	  if (Counters[i] > 0)
	    NotDone = 1;
	}
      }
      if (HeartBeat>1)
	fprintf(stderr," Tested %3d points.\n",j);
    }

    /* Convert Times to nsecs */
    for (i=0;i<NGaps;i++)
    {
      Times[i] = Times[i] * 1000.0 / (double) NAccesses.inner ;
      Times[i] = Times[i] / (double) NAccesses.outer;
      Trial = round( Times[i] / AddCostInNsecs );
      Cycles[i] = (int) Trial;
    }

    fprintf(LogFile,"\nGap Test @ %s b.\n",PrintNum(GapSizes[0]*UnitSize));
    fprintf(LogFile,"%s\tTime\tCycles\tGap Size\n","Spots");
    for (i=0;i<NGaps;i++)
    {
      fprintf(LogFile,"%3d\t%f\t%d\t%5s b\n",
	      Spots[i],Times[i],Cycles[i],PrintNum(GapSizes[i]*UnitSize));
    }

    nPoints++;

    /* Analysis */
    if (FirstTime)
    {
      FirstTime--;
      for (i=0;i<NGaps;i++)
	Pattern[i] = Cycles[i];
    }
    else 
    {
      for (i=0;i<NGaps;i++)
      {
	if (Pattern[i] < Cycles[i])
	{
	  fprintf(stderr,"Found L1 Cache @ size %s, associativity %d\n",
		  PrintNum(LevelSize*UnitSize),Spots[i]-1);
	  fprintf(LogFile,"Found L1 Cache @ size %s, associativity %d\n",
		  PrintNum(LevelSize*UnitSize),Spots[i]-1);
          WriteResult("AltCL1S",LevelSize*UnitSize);
	  WriteResult("AltCL1A",Spots[i]-1);
	  WriteResult("AltCL1L",Pattern[i]);
          MoreTests = 0;
	  NAFindLineSize( Spots[i], LevelSize );
          break;
          /* if we want to keep looking for higher levels, we need */
	  /* to figure out how to analyze the effect AND we need   */
          /* to reset the pattern, increase the increment, and go  */
          /* forward ... */
	  for (j=0;j<NGaps;j++)
	  {
	    Pattern[i] = Cycles[i]; 
	  }
          Increment = Min(LevelSize,512*1024/UnitSize);
	}
      }
    }

    if (LevelSize*UnitSize == 16384)           /* 16 K */
      Increment =  2048 / UnitSize;
    else if (LevelSize*UnitSize == 131072)     /* 128 K */
      Increment = 16384 / UnitSize;
    else if (LevelSize*UnitSize == 1048576)    /* 1 M */
      Increment = 131072 / UnitSize;
    else if (LevelSize*UnitSize == 8388608)    /* 8 M */
      Increment = 1048576 / UnitSize;
    else if (LevelSize*UnitSize == 16777216)    /* 16 M */
    {
      fprintf(stderr,"No cache found in first 16 MB.\n");
      fprintf(LogFile,"No cache found in first 16 MB.\n");
      WriteResult("AltCL1S",0);
      MoreTests = 0;
    }
    LevelSize = LevelSize + Increment;
  }

  fprintf(stderr,"Tested %s sizes in the memory hierarchy.\n",
	  PrintNum(nPoints));
  fprintf(LogFile,"Tested %s sizes in the memory hierarchy.\n",
	  PrintNum(nPoints));

  if (MemArray != (void **) NULL)
  {
    PACE_FreeMem(MemArray);
    MemArray = (void **) NULL;
  }
}



