#!/bin/bash

# Read the configuration file and generate the variables files
CF="../configuration.txt"
if [ ! -f ${CF} ]; then
  echo "${CF}: file does not exist."
  exit 1
fi

awk -f setup_env_variables_from_configuration_file.awk ${CF} | grep -v PACE_RCDB > vars_make

# Maybe we need it
#OPT=`grep COPT ${CF} | cut -d ' ' -f 2`
#echo "export CFLAGS=${OPT}" >> vars_make
#echo "export COPT=${OPT}" >> vars_make
#=======


# The following are the parameters for submit_job
echo "export NP: = 1" >> vars_make
echo "export MAX_TIME := 15:00:00" >> vars_make

#Define system variables
if [ -z "$VERSION" ]
then
  VERSION=`date "+%Y-%m-%d"`
fi
echo "export VERSION := ${VERSION}" >> vars_make

if [ -z "$SHORT_NAME" ]
then
  SHORT_NAME=`uname -n`
fi
echo "export SHORT_NAME := ${SHORT_NAME}" >> vars_make

if [ -z "$IP_ADDRESS" ]
then
  IP_ADDRESS="127.0.0.1"
fi
echo "export IP_ADDRESS := ${IP_ADDRESS}" >> vars_make

if [ -z "$LOCATION" ]
then
  LOCATION="Honululu"
fi
echo "export LOCATION := ${LOCATION}" >> vars_make

# test multi word export
echo "export TESTFOO := foo bar ;;" >> vars_make
