/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "RC.h"

/* first, define the structure of database entries, then include
   the file that contains the database entries */
typedef struct
{
    char *key;
    Database_Value value;
} Database_Entry;

#include "db_entries.c"



int database_is_initialized;

void RC_Init(void)
{
    database_is_initialized = 1;
} /* RC_Init */



Database_Value *RC_Query(char *key)
{
    int i = number_of_entries;

    if (!database_is_initialized)
    {
      /*	fprintf(stderr, "Database is not initialized; call RC_Init before calling RC_Query.\n");*/
	exit(-1);
    }

    while (database[i].key != NULL)
    {
      /*      fprintf(stderr, "Comparing %s\n         %s\n", key, database[i].key);*/
	if (!strcmp(database[i].key, key))
	    break;
	i--;
    }

    /* this is safe, b/c the final entry in the database is a null string
       and the value returned is the "NOT_FOUND_ERROR" enum type */
    return &(database[i].value);
	    
} /* RC_Query */



void RC_Final(void)
{
    database_is_initialized = 0;
} /* RC_Final */
