BEGIN{
    found_an_error = 0;
    next_entry = 1;
}

{
    if (NF != 2)
    {
	if (suppress_error_messages != 1)
	{
	    printf "PACE_RCDB is corrupted -- expecting <key, val> pairs\n";
	    if (NF == 1)
	    {
		plural = "";
		count = "only 1";
	    }
	    else
	    {
		plural = "s";
	    count = NF;
	    }
	    printf "\t\tOFFENDING LINE: >%s<\n\t\t(%d element%s on the line)\n", $0, count, plural;
	}
	found_an_error = 1;
    }
    else
    {
	already_there = 0;
	for(i=1;i<next_entry;i++)
	    if (key[i] == $1)
	    {
		value[i] = $2;
		already_there = 1;
	    }

	if (already_there == 0)
	{
	    key[next_entry] = $1;
	    value[next_entry] = $2;
	    next_entry++;
	}
    }
}


END{
    if (found_an_error >= 0)
    {
	printf "#include \"RC.h\"\n\n";
	printf "Database_Entry database[] = {\n\t{ NULL, NOT_FOUND_ERROR, {.integer_val = 0} },\n";
	for(i=1;i<next_entry;i++)
	{
	    printf "\t{\"%s\", {", key[i];
	    if (index(value[i], ".") == 0)
		printf "RC_INTEGER, {.integer_val";
	    else
		printf "RC_DOUBLE, {.double_val";
	    printf " = %s}} }, \n", value[i];
	}
	
	printf "\t{ NULL, NOT_FOUND_ERROR, {.integer_val = 0} }\n};\n";
	printf "int number_of_entries = %d;\n", next_entry-1;
    }
}