BEGIN{
    found_an_error = 0;
    next_entry = 1;
}

# this should look just like the input from write_RC.awk!
{
    if (NF != 2)
    {
	if (suppress_error_messages != 1)
	{
	    printf "PACE_RCDB is corrupted -- expecting <key, val> pairs\n";
	    if (NF == 1)
	    {
		plural = "";
		count = "only 1";
	    }
	    else
	    {
		plural = "s";
	    count = NF;
	    }
	    printf "\t\tOFFENDING LINE: >%s<\n\t\t(%d element%s on the line)\n", $0, count, plural;
	}
	found_an_error = 1;
    }
    else
    {
	already_there = 0;
	for(i=1;i<next_entry;i++)
	    if (key[i] == $1)
	    {
		value[i] = $2;
		already_there = 1;
	    }

	if (already_there == 0)
	{
	    key[next_entry] = $1;
	    value[next_entry] = $2;
	    next_entry++;
	}
    }
}


# separate the keys into their groups, and then output them
END{
    live_values_counter = 0;
    op_data_latency_counter = 0;
    op_data_parallel_ops_counter = 0;
    cost_add_counter = 0;
    parallel_contexts_counter = 0;
    cache_counter = 0;

    for (i=1;i<next_entry;i++)
    {
	if (index(key[i], "live_values") == 1)
	{
	    live_values_counter++;
	    
	    live_values_characteristics[live_values_counter] = key[i];
	    live_values_values[live_values_counter] = value[i];
	}
	else if (index(key[i], "op_data") == 1)
	{
	    if (index(key[i], "latency") != 0)
	    {
		op_data_latency_counter++;
		
		op_data_latency_characteristics[op_data_latency_counter] = key[i];
		op_data_latency_values[op_data_latency_counter] = value[i];
		
	    }
	    else # parallel_ops
	    {
		op_data_parallel_ops_counter++;
		
		op_data_parallel_ops_characteristics[op_data_parallel_ops_counter] = key[i];
		op_data_parallel_ops_values[op_data_parallel_ops_counter] = value[i];
	    }
	}
	else if (index(key[i], "cost_add") == 1)
	{
	    cost_add_counter++;
	    
	    cost_add_characteristics[cost_add_counter] = key[i];
	    cost_add_values[cost_add_counter] = value[i];
	}
	else if (index(key[i], "parallel_contexts") == 1)
	{
	    parallel_contexts_counter++
	    
	    parallel_contexts_characteristics[parallel_contexts_counter] = key[i];
	    parallel_contexts_values[parallel_contexts_counter] = value[i];
	}
	else if (index(key[i], "cache") == 1)
	{
	    cache_counter++;
	    
	    cache_characteristics[cache_counter] = key[i];
	    cache_values[cache_counter] = value[i];
	}
    } # for-loop to categorize values
    
    #output the data
    printf "This data was gathered for the system: %s\n\n", system_name;

    system("cat ./text_for_human_readable_report/cache_levels.txt");
    if (cache_counter == 0)
	print "UNABLE TO RELIABLY READ VALUES FOR THIS CHARACTERISTIC.\n";
    else
    {
	if (cache_counter == 1)
	    printf "On this machine, the measured value is:\n\n";
	else
	    printf "On this machine, the measured values are:\n\n";
	# find the largest width
	largest_width = 0;
	for (i=1;i<=cache_counter;i++)
	    if (length(cache_characteristics[i]) > largest_width)
		largest_width = length(cache_characteristics[i]);
	
	for (i=1;i<=cache_counter;i++)
	    printf "%-" largest_width "s\t%s\n", cache_characteristics[i], cache_values[i];
    }
    printf "\n\n";
    
    system("cat ./text_for_human_readable_report/operation_latency.txt");
    if (op_data_latency_counter == 0)
	print "UNABLE TO RELIABLY READ VALUES FOR THIS CHARACTERISTIC.\n";
    else
    {
	if (op_data_latency_counter == 1)
	    printf "On this machine, the measured value is:\n\n";
	else
	    printf "On this machine, the measured values are:\n\n";
	# find the largest width
	largest_width = 0;
	for (i=1;i<=op_data_latency_counter;i++)
	    if (length(op_data_latency_characteristics[i]) > largest_width)
		largest_width = length(op_data_latency_characteristics[i]);
	
	for (i=1;i<=op_data_latency_counter;i++)
	    printf "%-" largest_width "s\t%s\n", op_data_latency_characteristics[i], op_data_latency_values[i];
    }
    printf "\n\n";
    
    system("cat ./text_for_human_readable_report/parallel_contexts.txt");
    if (parallel_contexts_counter == 0)
	print "UNABLE TO RELIABLY READ VALUES FOR THIS CHARACTERISTIC.\n";
    else
    {
	if (parallel_contexts_counter == 1)
	    printf "On this machine, the measured value is:\n\n";
	else
	    printf "On this machine, the measured values are:\n\n";
	# find the largest width
	largest_width = 0;
	for (i=1;i<=parallel_contexts_counter;i++)
	    if (length(parallel_contexts_characteristics[i]) > largest_width)
		largest_width = length(parallel_contexts_characteristics[i]);
	
	for (i=1;i<=parallel_contexts_counter;i++)
	    printf "%-" largest_width "s\t%s\n", parallel_contexts_characteristics[i], parallel_contexts_values[i];
    }
    printf "\n\n";
    
    system("cat ./text_for_human_readable_report/live_values.txt");
    if (live_values_counter == 0)
	print "UNABLE TO RELIABLY READ VALUES FOR THIS CHARACTERISTIC.\n";
    else
    {
	if (live_values_counter == 1)
	    printf "On this machine, the measured value is:\n\n";
	else
	    printf "On this machine, the measured values are:\n\n";
	# find the largest width
	largest_width = 0;
	for (i=1;i<=live_values_counter;i++)
	    if (length(live_values_characteristics[i]) > largest_width)
		largest_width = length(live_values_characteristics[i]);
	
	for (i=1;i<=live_values_counter;i++)
	    printf "%-" largest_width "s\t%s\n", live_values_characteristics[i], live_values_values[i];
    }
    printf "\n\n";
    
    system("cat ./text_for_human_readable_report/operation_time.txt");
    if (cost_add_counter == 0)
	print "UNABLE TO RELIABLY READ VALUES FOR THIS CHARACTERISTIC.\n";
    else
    {
	if (cost_add_counter == 1)
	    printf "On this machine, the measured value is:\n\n";
	else
	    printf "On this machine, the measured values are:\n\n";
	# find the largest width
	largest_width = 0;
	for (i=1;i<=cost_add_counter;i++)
	    if (length(cost_add_characteristics[i]) > largest_width)
		largest_width = length(cost_add_characteristics[i]);
	
	for (i=1;i<=cost_add_counter;i++)
	    printf "%-" largest_width "s\t%s\n", cost_add_characteristics[i], cost_add_values[i];
    }
    printf "\n\n";
    
    system("cat ./text_for_human_readable_report/parallel_ops.txt");
    if (op_data_parallel_ops_counter == 0)
	print "UNABLE TO RELIABLY READ VALUES FOR THIS CHARACTERISTIC.\n";
    else
    {
	if (op_data_parallel_ops_counter == 1)
	    printf "On this machine, the measured value is:\n\n";
	else
	    printf "On this machine, the measured values are:\n\n";
	# find the largest width
	largest_width = 0;
	for (i=1;i<=op_data_parallel_ops_counter;i++)
	    if (length(op_data_parallel_ops_characteristics[i]) > largest_width)
		largest_width = length(op_data_parallel_ops_characteristics[i]);
	
	for (i=1;i<=op_data_parallel_ops_counter;i++)
	    printf "%-" largest_width "s\t%s\n", op_data_parallel_ops_characteristics[i], op_data_parallel_ops_values[i];
    }
    printf "\n\n";    
}