#!/bin/bash

#source env_vars
OPTIMIZATION_FLAG=${COPT_TARGET}
OPTIMIZATION_FLAG_HOST=${COPT_TARGET}
OPTIMIZATION_FLAG_TARGET=${COPT_TARGET}

export OPTIMIZATION_FLAG
export OPTIMIZATION_FLAG_HOST
export OPTIMIZATION_FLAG_TARGET

# start at [110:120] interval
let PERF_DROP_INIT=120
# report 10 % intervals
let PERF_DROP_STEP=10
let PERF_DROP_MAX=210

export PERF_DROP_INIT
export PERF_DROP_STEP
export PERF_DROP_MAX


exec 2> err.log
AFFINITY_INCLUDE=""
AFFINITY_LDFLAG=""
AFFINITY_LDPATH=""
AFFINITY_TYPE="-D NO_AFFINITY"

if [ -n "$HWLOC_PATH_TARGET" ]
then
  echo "Using hwloc"
  AFFINITY_LDFLAG="-lhwloc"
  AFFINITY_LDPATH="-L $HWLOC_PATH_TARGET/lib"
  AFFINITY_TYPE="-D HWLOC_AFFINITY"
  AFFINITY_INCLUDE="-I $HWLOC_PATH_TARGET/include"
else
  $CC_TARGET $COPT_TARGET $PTHREAD_LIBRARY_LINKER_FLAG_TARGET pthreadtest.c -o pthreadtest
  if [ -e "./pthreadtest" ]
  then
    echo "Using pthread affinity"
    AFFINITY_TYPE="-D PTHREAD_AFFINITY"
  else
    echo "Using no affinity"
    AFFINITY_TYPE="-D NO_AFFINITY"
  fi
fi

export AFFINITY_INCLUDE
export AFFINITY_LDFLAG
export AFFINITY_LDPATH
export AFFINITY_TYPE

cd double-tests
. ./build.sh >> err.log
cd ..

cd integer-tests
. ./build.sh >> err.log
cd ..

