/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
#include <stdio.h>

#define SIGPERFDROP 1.15

/* Get the number of threads at which performance drops by a factor of
 * <perf_drop>.
 */
void analyse(double * ts, int max_num_threads, double perf_drop) {
  int i;
  for (i=2; i<max_num_threads; ++i) {

    if (ts[i] > ts[1]* perf_drop) {
      printf("threads:%d\n", i-1);
      break;
    }
  }
  if (i==max_num_threads) printf("threads:-1\n"); 
}


int check_increasing(double * ts, int max_num_threads, int curr) { 
  int num_beyond_curr = max_num_threads - curr;
  /* Check that the next two points are also significantly larger */
  if (num_beyond_curr > 2) {
    if (ts[curr+1] > ts[1] * SIGPERFDROP &&
        ts[curr+2] > ts[1] * SIGPERFDROP)
      return 1;
  } else return 1;
  return 0;
}

void analyse_number_of_threads(double * ts, int max_num_threads) {
  int i; 
  for (i=2; i <= max_num_threads; ++i) {
    if (ts[i] > ts[1] *  SIGPERFDROP &&
        check_increasing(ts, max_num_threads, i) ) {
      printf("<int_context> %d </int_context>\n", i-1);
      printf("<integer_context>%d</integer_context>\n", i-1);
#if 0
      printf("<core_est>%d</core_est>\n", i-1);
#endif
      break;
    }
  }
}

void analyse_performance_degradation(double * ts, int max_num_threads, int initial_perf_drop, int perf_drop_step) {
  int i;
  int perf_drop = initial_perf_drop;

   
  /* Ensure we are actually over the initial performance drop */
  if (ts[max_num_threads]/ts[1] < perf_drop/100.0) {
    printf("<Error/>\n"); 
    return;
  }
  printf("<performance_degradation>\n");
  for (i=2; i<=max_num_threads; ++i) {
    if (ts[i] / ts[1] >= (perf_drop-perf_drop_step)/100.0) {
      while (ts[i] / ts[1] >= (perf_drop)/100.0) {
        perf_drop += perf_drop_step;
      }
      printf("  <tuple>\n");
      printf("    <first>%d-%d</first><second>%d</second>\n",perf_drop-perf_drop_step , perf_drop, i);
      printf("  </tuple>\n");
      perf_drop += perf_drop_step;
    }
  }
  printf("</performance_degradation>\n");
  analyse_number_of_threads(ts, max_num_threads);
#if 0
  for (i=2; i<=max_num_threads; ++i) {
    double expected_min_perf_drop = (1.0/(i-1))+1.0;
    if (i==2) expected_min_perf_drop = 1.7;
    if (ts[i]/ts[1] > expected_min_perf_drop) {
      printf("<core_est>%d</core_est>\n", i-1);
      break;
    }
  }
#endif
}
