#ifndef __DISSEM_BARRIER_H__
#define __DISSEM_BARRIER_H__

/* Overestimate line size for most current architectures */
#define LINESIZE 128
#define PADDING (LINESIZE/sizeof(char))

typedef union barrier_node_t {
  struct {
    volatile unsigned char flag[2];
    union barrier_node_t * partner; 
  } data;
  /* Pad data to LINESIZE*/
  char pad[PADDING];
} dissem_barrier_node;


typedef struct dissem_barrier_t {
  void * mem_to_free;
  dissem_barrier_node * nodes;
} dissem_barrier;

typedef struct dissem_barrier_thread_local_data_t {
  dissem_barrier_node * nodes;
  unsigned int  num_threads;
  unsigned int  log_num_threads;
  unsigned int  thread_id;
  unsigned char sense; 
  unsigned char parity;
} dissem_barrier_thread_local_data;

/* Returns 0 on success and 1 on failure */
int dissem_barrier_create(unsigned num_threads, dissem_barrier * b);

void dissem_barrier_destroy(dissem_barrier * b);

void dissem_barrier_wait(dissem_barrier_thread_local_data * d);

void dissem_barrier_thread_local_data_init(dissem_barrier_thread_local_data * d, dissem_barrier * b, unsigned int thread_id, unsigned int num_threads);

#endif
