#!/bin/bash

if [ $# -lt 3 ] ; then
  echo "./run-with-timeout.sh [timeout] [program] [arguments]"
  exit 1
fi

# Check to see whether the script is started in guard mode
GUARDED=""
if [ "$1" = "-guard" ]
then
  GUARDED=$2
  # Remove -guard and proc-id of guarded process from args
  shift
  shift
fi

# Store timeout and remove timeout from args
let TIMEOUT=$1
shift

if [ -z "$GUARDED" ]
then
  # Start the guard in parallel
  $0 -guard $$ $TIMEOUT $* &
  # Start the program i.e [program] [arguments]
  exec "$@"
else
  # Redirect output to trash
  exec > /dev/null 2>&1
  let SEC=0
  while [ $SEC -lt $TIMEOUT ]
  do
    sleep 2
    # Check if the guarded process is still alive
    kill -0 $GUARDED
    # Guarded process died. Exit
    if [ $? -eq 1 ]
    then
      exit 0
    fi
    let SEC=$SEC+1
  done
  # Time execeeds bounds. Kill guarded process.
  kill $GUARDED && (sleep 2; kill -1 $GUARDED) && (sleep 2; kill -9 $GUARDED)
fi

exit 0
