/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <stdint.h>

/* always call this code with an argument > 2! */
int main(int argc, char **argv)
{
    int64_t i, j, k, iterations = 100;
    int switch_val = atoi(argv[1]);
    struct timeval timer_val1, timer_val2;
    double start, finish;
    double time = 0.0;
    double max_time = 2.0;

    if (argc < 2)
	switch_val = 2;
    if (argc > 2)
    {
	max_time = atof(argv[2]);
	/*	printf("max_time = %1.4f\n", max_time);*/
    }
    if (argc > 3)
    {
    }

    while (time < max_time)
    {
	iterations *= 10;
	if (iterations > INT64_MAX-(int64_t)(1))
	{
	    fprintf(stderr, "Unable to figure out how many iterations to run.\n");
	    exit(-1);
	}
	gettimeofday(&timer_val1, NULL);
	for(i=0;i<iterations;i)
	    switch(switch_val++)
	    {
	        case 1:
		    i--;
		    break;
	        default:
		    i++;
	    };
	gettimeofday(&timer_val2, NULL);
	start = timer_val1.tv_sec + (timer_val1.tv_usec/1000000.0);
	finish = timer_val2.tv_sec + (timer_val2.tv_usec/1000000.0);
	time = finish-start;
	/*	    fprintf(stdout, "%lld\t%s%1.5f\t%1.5f\t%1.5f\n", (iterations +i)/2, ((iterations+i)/2 < 10000000)?"\t":"", start, finish, time);*/
    }
    fprintf(stdout, "%lld\n", (iterations +i)/20000);
} /* main */
