/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>

main(int argc, char **argv)
{
    int i, j, k, a_lot = 1000, number_of_declarations = ((a_lot/100)>10)?a_lot/100:10;
    FILE *next_file;
    char *files[] = {"all_adds_int.c", "mixed_int.c", "all_adds_float.c", "mixed_float.c"};
    char filename[1000];
    char *kinds[] = {"all_adds", "mixed"};
    char *type_names[] = {"int32", "int64", "float", "double"};
    char *types[] = {"int32_t", "int64_t", "float", "double"};

    if (argc > 1)
	a_lot = atoi(argv[1]);

    for(k=0;k<2;k++)
	for(j=0;j<4;j++)
	{
	    sprintf(filename, "two_argument_%s_%s.c", kinds[k], type_names[j]);
	    next_file = fopen(filename, "w");
	    if (!next_file)
	    {
		fprintf(stderr, "%s failed to open for writing.\n", filename);
		exit(0);
	    }
	    fprintf(next_file, "#include <stdint.h>\n%s two_argument_%s_%s(%s x0, %s x1, %s x2)\n{\n\t%s xt", types[j], kinds[k], type_names[j], types[j], types[j], types[j], types[j]);
	    for(i=3;i<number_of_declarations;i++)
		fprintf(next_file, ", x%d", i);
	    fprintf(next_file, ";\n");
	    for(i=0;i<a_lot;i++)
	    {
		fprintf(next_file, "\txt = x%d %s x%d;\n", (i)%number_of_declarations, (k%2)?"*":"+", (i+1)%number_of_declarations);
		fprintf(next_file, "\tx%d = xt + x%d;\n", (i+3)%number_of_declarations, (i+2)%number_of_declarations);
	    }
	    fprintf(next_file, "\treturn x%d;\n}\n", (i-1)%number_of_declarations);
	    fclose(next_file);
	}

} /* main */
