/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
#include <stdio.h>
#include <string.h>

#define MAX_VARS 100


main(int argc, char **argv[])
{
    int i, j, k, a_lot = 1000;
    char *type_names[] = {"int32", "int64", "float", "double"};
    char *types[] = {"int32_t", "int64_t", "float", "double"};
    char *forms[] = {"all_adds", "mixed"};
    char filename_array[1000];
    char *filename = &filename_array[0];
    FILE *next_file;
    
    if (argc > 1)
	a_lot = atoi(argv[1]);
    
    for(k=0;k<2;k++)
	for(j=0;j<4;j++)
	{
	    i = sprintf(filename, "three_argument_%s_%s.c", forms[k], type_names[j]);
	    next_file = fopen(filename, "w");
	    fprintf(next_file, "#include <stdint.h>\n%s three_argument_%s_%s(%s x0, %s x1, %s x2)\n{\n\t%s x3", types[j], forms[k], type_names[j], types[j], types[j], types[j], types[j]);
	    for(i=4;i<MAX_VARS;i++)
		fprintf(next_file, ", x%d", i);
	    fprintf(next_file, ";\n");
	    for(i=0;i<a_lot;i++)
		fprintf(next_file, "\tx%d = (x%d %s x%d) + x%d;\n", (i+3)%MAX_VARS, (i+2)%MAX_VARS, (k%2)?"*":"+", (i+1)%MAX_VARS, i%MAX_VARS);
	    fprintf(next_file, "\treturn x%d;\n}\n", (i-1)%MAX_VARS);
	  fclose(next_file);
	}
} /* main */
