/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
#include <stdio.h>
extern void exit();

main(int argc, char **argv)
{
    int i, j, k;
    int number_of_lines = 10000;
    int number_of_parameters_to_try = 32;
    int global_frequency = 100;
    char output_file_name[1000], procedure_name[1000];
    FILE *output_file;
    char *type = "int";
    int number_of_declarations = 100;
    int bigger_than_number_of_lines;

    if (argc > 1)
	number_of_lines = atoi(argv[1]);

    bigger_than_number_of_lines = number_of_lines+3;

    if (argc > 2)
	for(i=0, number_of_parameters_to_try=1;i<atoi(argv[2]);i++)
	    number_of_parameters_to_try *= 2;
    if (argc > 3)
	global_frequency = atoi(argv[3]);
    if (argc>4)
	type = argv[4];

    /* the -1 case is for when we want to time no procedure calls at all */
    for(i=-1;i<=number_of_parameters_to_try;i=(i==-1)?0:(!i)?1:i+1)
    {
	int call_count = 0;
	int frequency = (i == -1)?bigger_than_number_of_lines:global_frequency;

	/* put out the header info */
	sprintf(output_file_name, "lines_%d_parameters_%03d_frequency_%d_type_%s.c", number_of_lines, (i<0)?number_of_lines:i, global_frequency, type);
	sprintf(procedure_name, "lines_%d_parameters_%03d_frequency_%d_type_%s", number_of_lines, (i<0)?bigger_than_number_of_lines:i, global_frequency, type);
	output_file = fopen(output_file_name, "w");
	if (!output_file)
	{
	    fprintf(stderr, "Failed trying to open %s\n", output_file_name);
	    exit(0);
	}
	fprintf(output_file, "#include <stdio.h>\n#include <sys/time.h>\n");
	fprintf(output_file, "extern %s foo();\nextern %s bar_%d();\n", type, type, (i<0)?number_of_lines:i);
	fprintf(output_file, "double %s(int trips, double modifier)\n{\n", procedure_name);
	fprintf(output_file, "\tint i;\n");
	fprintf(output_file, "\tdouble start, finish;\n");
	fprintf(output_file, "\tstruct timeval timer_val1, timer_val2;\n");
	fprintf(output_file, "\t%s ", type);
	for(j=0;j<number_of_declarations;j++)
	    fprintf(output_file, "%sr%d=foo()", (!j)?"":", ", j);
	fprintf(output_file, ";\n\n");

        fprintf(output_file, "\tgettimeofday(&timer_val1, NULL);\n");
	fprintf(output_file, "\tfor(i=0;i<trips;i++)\n\t{\n");

	/* put out the lines of code */
	for(j=3;j<=number_of_lines+3-(i == -1)?(number_of_lines/global_frequency):0;j++)
	    if (!(j%frequency) && (j-i)>=0)
	    {
		fprintf(output_file, "\tr%d = bar_%d(", j%number_of_declarations, (i<0)?number_of_lines:i);
		for(k=j-i;k<j; k++)
		    fprintf(output_file, "%s%d", (k==j-i)?"":", ", k%number_of_declarations);
		fprintf(output_file, ");\n");
		call_count++;
	    }
	    else
		fprintf(output_file, "\tr%d = r%d + r%d;\n", j%number_of_declarations, (j-1)%number_of_declarations, (j-2)%number_of_declarations);

	fprintf(output_file, "\t}\n\tgettimeofday(&timer_val2, NULL);\n\n");
        fprintf(output_file, "\tstart = timer_val1.tv_sec + (timer_val1.tv_usec/1000000.0);\n");
        fprintf(output_file, "\tfinish = timer_val2.tv_sec + (timer_val2.tv_usec/1000000.0);\n");
	if (i<0)
	    fprintf(output_file, "\n\tfprintf(stdout, \"%%s%%1.8f\\t%%1.8f\\tno calls\\t%%d adds\\t%%1.12f cost/add\\t%d frequency\\t%d lines\\n\", (r%d)?\"\":\" \", finish-start, finish-start-modifier, %d*trips, (finish-start)/((double)(%d*trips)));\n", frequency, j-1, (j-1)%number_of_declarations, number_of_lines, number_of_lines);
	else
	{
	    if (frequency == 1)
		fprintf(output_file, "\n\tfprintf(stdout, \"%%s%%1.8f\\t%%1.8f\\t%03d parameters\\t%%d calls\\t%%1.12f adds/call\\t%d frequency\\t%d lines\\n\", (r%d)?\"\":\" \", finish-start, finish-start, %d*trips, (finish-start)/((double)(modifier)));\n", i, frequency, j-1, (j-1)%number_of_declarations, call_count, call_count);
	    else
		fprintf(output_file, "\n\tfprintf(stdout, \"%%s%%1.8f\\t%%1.8f\\t%03d parameters\\t%%d calls\\t%%1.12f cost/call\\t%d frequency\\t%d lines\\n\", (r%d)?\"\":\" \", finish-start, finish-start-modifier, %d*trips, (finish-start-modifier)/((double)(%d*trips)));\n", i, frequency, j-1, (j-1)%number_of_declarations, call_count, call_count);
	}

	/* put out the footer info */
	if (i == -1)
	    fprintf(output_file, "\n\treturn finish-start;\n}/* %s */\n", procedure_name);
	else
	    fprintf(output_file, "\n\treturn modifier;\n}/* %s */\n", procedure_name);

	fclose(output_file);
    }

    /* put out the controlling program */
    sprintf(output_file_name, "main_lines_%d_parameters_%03d_frequency_%d_type_%s.c", number_of_lines, i, global_frequency, type);
    output_file = fopen(output_file_name, "w");
    if (!output_file)
    {
	fprintf(stderr, "Failed trying to open %s\n", output_file_name);
	exit(0);
    }
    fprintf(output_file, "#include <stdio.h>\n");
    for(i=-1;i<=number_of_parameters_to_try;i=(i==-1)?0:(!i)?1:i+1)
	fprintf(output_file, "extern double lines_%d_parameters_%03d_frequency_%d_type_%s();\n\n", number_of_lines, (i==-1)?bigger_than_number_of_lines:i, global_frequency, type);

    /* put out the "bar" functions */
    for(i=0;i<=number_of_parameters_to_try;i=(!i)?1:i+1)
    {
	fprintf(output_file, "bar_%d(", i);
	for(j=0;j<i;j++)
	    fprintf(output_file, "%sp%d", (!j)?"":", ", j);
	fprintf(output_file, ")\n{\n\treturn 1;\n} /* bar_%d */\n\n", i);
    }

    /* put out the "foo" function */
    fprintf(output_file, "char *pointer_to_first_arg;\n");
    fprintf(output_file, "%s foo(void)\n{\n\tstatic arg_index = 0;\n\n\tif (!pointer_to_first_arg[arg_index])\n\t\targ_index = 0;\n\n\treturn ((%s)pointer_to_first_arg[arg_index]);\n} /* foo */\n", type, type);

    /* put out main */
    fprintf(output_file, "\n\nint main(int argc, char **argv)\n{\n");
    fprintf(output_file, "\tint trips = 100;\n");
    fprintf(output_file, "\tdouble modifier = 0.0;\n\n");
    fprintf(output_file, "\tpointer_to_first_arg = argv[0];\n");
    fprintf(output_file, "\tif (argc > 1) trips = atoi(argv[1]);\n\n");
    
    for(i=-1;i<=number_of_parameters_to_try;i=(i==-1)?0:(!i)?1:i+1)
	fprintf(output_file, "\tmodifier = lines_%d_parameters_%03d_frequency_%d_type_%s(trips, modifier);\n", number_of_lines, (i==-1)?bigger_than_number_of_lines:i, global_frequency, type);
    fprintf(output_file, "} /* main */\n");

    /* finally, print to stdout the commands to compile, so
       that this program can be run and then fed into a compile command
       automatically */
    fprintf(stdout, "#! /bin/bash\n");
    fprintf(stdout, "$CC $CCOMPILE_ONLY_FLAG $COPT %s\n", output_file_name);
    for(i=-1;i<=number_of_parameters_to_try;i=(i==-1)?0:(!i)?1:i+1)
    {
	fprintf(stdout, "$CC $CCOMPILE_ONLY_FLAG $COPT lines_%d_parameters_%03d_frequency_%d_type_%s.c\n", number_of_lines, (i==-1)?number_of_lines:i, global_frequency, type);
    }
    fprintf(stdout, "$CC $COPT %s ", output_file_name);
    for(i=-1;i<=number_of_parameters_to_try;i=(i==-1)?0:(!i)?1:i+1)
	fprintf(stdout, "lines_%d_parameters_%03d_frequency_%d_type_%s.o ", number_of_lines, (i==-1)?number_of_lines:i, global_frequency, type);
    fprintf(stdout, "\n");

} /* main */
