/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

/* always call this code with an argument >= 2! */
int main(int argc, char **argv)
{
    int i, j, k, iterations = 100;
    int switch_val;
    struct timeval timer_val1, timer_val2;
    double start, finish;
    double time = 0.0;

    if (argc > 1)
	switch_val = atoi(argv[1]);

    if (argc < 2)
	switch_val = 2;
    
    while (time < 1.0)
    {
	iterations *= 10;
	if (iterations > 1000000001)
	{
	    fprintf(stderr, "Unable to figure out how many iterations to run.\n");
	    exit(-1);
	}
	gettimeofday(&timer_val1, NULL);
	for(i=0;i<iterations;i)
	    switch(switch_val++)
	    {
	        case 1:
		    i--;
		    break;
	        default:
		    i++;
	    };
	gettimeofday(&timer_val2, NULL);
	start = timer_val1.tv_sec + (timer_val1.tv_usec/1000000.0);
	finish = timer_val2.tv_sec + (timer_val2.tv_usec/1000000.0);
	time = finish-start;
	/*    fprintf(stdout, "%d\t%s%1.5f\t%1.5f\t%1.5f\n", (iterations +i)/2, ((iterations+i)/2 < 10000000)?"\t":"", start, finish, time);*/
    }
    fprintf(stdout, "%d\n", (iterations +i)/20000);
} /* main */
