BEGIN{
    if (length(ENVIRON["ASSEMBLY_COMMENT_START"]) == 0)
    {
        if ($1 == "verbose")
	    printf "Unable to find the assembly-code comment start.  Assuming two semicolons.\n";
	comment_start = ";;";
    }
    else
	comment_start = ENVIRON["ASSEMBLY_COMMENT_START"];

    if (length(ENVIRON["ASSEMBLY_COMMENT_END"]) == 0)
    {
        if ($1 == "verbose")
	    printf "Unable to find the assembly-code comment end.  Assuming newline.\n";
	comment_end = "";
    }
    else
	comment_end = ENVIRON["ASSEMBLY_COMMENT_END"];

    reading_multi_line_comment = 0;

    
#printf "length comment_end = %d(>%s<)\n", length(comment_end), comment_end;
}


{
#printf ">>>>%s<<<<\n", $0;
    # it's a whole lot easier (i.e., fewer possibilities) to handle
    # the case of the comment's end is just a newline; in the case
    # where there's a close-comment string, then we have to worry about
    # imbedded comments and multi-line comments
    # NOTE : we'll want to strip whitespace and only print lines that
    # have actual code on them, so instead of just printing out each
    # line, we'll simply write changes to $0 so that subsequent matching
    # rules can strip whitespace and finally decide if the line needs
    # to be printed out

    if (length(comment_end) > 0)
    {
	if (reading_multi_line_comment == 1)
	{
#printf "\t\tREADING MULTILINE COMMENT\n";
	    if (index($0, comment_end) != 0)
	    {
		afterwards = index($0, comment_end) + length(comment_end);
		$0 = substr($0, afterwards, (length($0)-afterwards));

		reading_multi_line_comment = 0;
#printf "\t\tNEW $0: >%s<\n", $0;
	    }
	    else # otherwise, eat the whole line
	    {
		$0 = "";
#printf "\t\tSETTING $0 to NULL.\n";		
	    }
	}
	else
	{
	    comment_start_position = index($0, comment_start);
#printf "\tcomment_start_position = %d\n", comment_start_position;
	    # if there's a comment on this line, then we have to 
	    # find the end-comment string, which could be on a successive
	    # line
	    if (comment_start_position != 0)
	    {
		comment_end_position = index($0, comment_end);
#printf "\tcomment_end_position = %d\n", comment_end_position;
		# if the end-comment string is on this line, then we need
		# to splice out the comment from the rest of the line; if it
		# is not on this line, then we read to the end of the line
		# and set the reeading_multi_line_comment flag
	        if (comment_end_position > comment_start_position)
		{
		    starting_slice = substr($0, 1, comment_start_position-1);
		    ending_slice = substr($0, comment_end_position+length(comment_end), length($0));
#printf "\t\tSPLICING together >%s< and >%s<\n", starting_slice, ending_slice;
		    $0 = (starting_slice ending_slice);
		}
		else
		{
#printf "\t\tCUTTING OUT THE END\n";
		    $0 = substr($0, 1, comment_start_position-1);
		    reading_multi_line_comment = 1;
		}
	    }
	    else # this line has no comments, so let it fall through to the
		 # next rule
		;
	}
    }
    else if (index($0, comment_start) != 0)
    {
	if (index($0, comment_start) != 1)
	    $0 = substr($0, 1, index($0, comment_start)-1);
    }
    else
	;
}

{sub(/^[ \t]+/, "")}

length($0) > 0
