/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
#include <stdio.h>
#include <string.h>

int MAX = 129;
int LINES = 10000;

int main(int argc, char **argv)
{
    FILE *current_file;
    int pressure, i, j, k;
    char output_filename[1000];
    char *type = "int32_t";
    char *type_name = "int32";
    char *operations[] = {"+", "-", "*", "/"};
    char *operation = operations[0];
    char *operation_strings[] = {"addition","subtraction","multiplication","division" };
    char *operation_string = operation_strings[0];

    if (argc > 1)
	if (argv[1][0] == 'f')
	{
	    type = "float";
	    type_name = "float";
	}
	else if (argv[1][0] == 'd')
	{
	    type = "double";
	    type_name = "double";
	}
        else if (argv[1][0] == '6')
	{
	    type = "int64_t";
	    type_name = "int64";
	}
    if (argc > 2)
	LINES = atoi(argv[2]);
    if (argc > 3)
	MAX = atoi(argv[3]);
    if (argc > 4)
    {
	operation = operations[atoi(argv[4])];
	operation_string = operation_strings[atoi(argv[4])];
    }

    /*    fprintf(stderr, "operation = %s\n", operation);*/

    for(pressure=2; pressure<MAX; pressure++)
    {
	/* open the file */
	sprintf(output_filename, "registers_%s_%05d_%d_%s.c", type_name, pressure, LINES, operation_string);
	current_file = fopen(output_filename, "w");

	/* first, put out the initializations */
	fprintf(current_file, "#include <stdint.h>\nextern %s foo();\n", type);
	output_filename[strlen(output_filename)-2] = '\0';
	fprintf(current_file, "%s %s(%s a, %s b)\n{\n\t%s ", type, output_filename, type, type, type);
	for(i=0;i<LINES;i++)
	{
	    fprintf(current_file, "r%d, ", i);
	}
	fprintf(current_file, "r%d;\n", i);

	/* next, put out the code */
	for(i=0;i<2;i++)
	    fprintf(current_file, "\tr%d = foo();\n", i);
	for(/*i is already init'd to 2*/;i<pressure;i++)
	    fprintf(current_file, "\tr%d = r%d %s r%d;\n", i, i-1, operation, i-2);
	for(/*already init'd to pressure*/;i<LINES-pressure;i++)
	    fprintf(current_file, "\tr%d = r%d %s r%d;\n", i, i-1, operation, i-pressure);
	for(/*i is already init'd to LINES-pressure*/j=0;i<LINES;j++,i++)
	    fprintf(current_file, "\tr%d = r%d %s r%d;\n", i, i-1, operation, i-pressure+j);

	/* finally, put out the cleanup */
	/*	fprintf(current_file, "\n\tr%d = ", i);
		/*	for(j=1;j<pressure;j++)
		/*	    fprintf(current_file, "r%d + ", i-j);
		/*	fprintf(current_file, "r%d;\n", i-j);*/
	fprintf(current_file, "\treturn r%d;\n}\n", i-1);
	fclose(current_file);
    }

} /* main */
