BEGIN{
    first = 1;
    found_it = 0;
    number_of_lines = 1000;
    delta_total = 0;
    input_line_count = 0;
}

# The input looks like: <line_count> registers_float_<pressure>.s
# There are two problems with the measurements:
#    1) if the size of the very first .s file is twice (or more) the number
#       of lines of C code (from which the .s was generated), then it's
#       likely that there aren't registers of that type; if we see this,
#       then we need to make the definitive change (the "jump") (which ought
#       to mark the transition from no spill-code to some spill-code) more
#       demanding
#    2) the number of instructions that get added to each successive file
#       tends to grow by a small amount, usually b/c each successive file
#       needs an extra initialization, and each initialization is a f(x)
#       call -- and each f(x) call tends to add a >1 number of assembly-code
#       instructions; thus, as the number-of-additional-insts * test-# gets
#       close to the starting number of lines, the "jump" in the data will
#       be hidden (more precisely, we incorrectly find a "jump" when there
#       isn't one); the solution to this problem is to cut off the analysis
#       and go to larger numbers of lines
{
    if (index($1, "total") != 1)
    {
	input_line_count++;
	line_count = $1;
	fields = split($2, a, "[_.]");
	current_register_pressure = a[3];
	if (first == 1)
	{
	    first = 0;
	    number_of_lines = a[4];
	    last_measurement = line_count;

	    # if the .s file is significantly longer than the .c file,
	    # then it's likely that the compiler is putting in useless
	    # code (that is, it's not using a very good allocator),
	    # so we need to report that the results are unlikely to be helpful
	    if (last_measurement > (number_of_lines*1.5))
	    {
		unlikely = 1;
		threshold_multiplier = last_measurement/(number_of_lines);
	    }
	    else
		unlikely = 0;

	    last_register_pressure = current_register_pressure;
	    type_of_register = a[2];
	}
	else
	{
            # because the number of lines of code changes slightly in
            # between runs before spill code gets inserted, we keep
            # a running average of the delta between successive measurements;
            # as long as the next delta is within some threshold of the
            # running average, then we haven't seen spill code inserted;
            # if we have the "unlikely" bit set, then the threshold is
            # considerably higher -- some function of the total number of
            # instructions, rather than a function of the delta between
            # measurements
            if (found_it == 0)
	    {
		delta_addition = line_count-last_measurement;
                if (delta_addition < 0)
                    delta_addition = -delta_addition;
                delta_total += delta_addition;
                delta_average = delta_total / input_line_count;

		if (number_of_lines/current_register_pressure > (2*delta_average))
		    threshold = number_of_lines/current_register_pressure;
		else
		    threshold = 2*delta_average;
		    
		if (unlikely == 1)
		    threshold *= threshold_multiplier;

		if (line_count > (last_measurement + threshold))
			found_it = last_register_pressure;
		else
		{
		    last_measurement = line_count;
		    last_register_pressure = current_register_pressure;
		}
	    }
	}
    }
}

END{
    # obviously, this is a useless if, but we left it in b/c we wanted
    # to show how the code is designed (and, really, it has no measurable
    # impact on performance!)
    if (found_it == 0)
    {
	printf "0 %s registers.\n", type_of_register;
#	if (unlikely == 1)
#	    printf "WARNING: IT IS UNLIKELY THAT THERE ARE ANY REGISTERS OF TYPE %s.\n", type_of_register;
#	else
#	    printf "ERROR: NO DISCERNIBLE REGISTER FOUND FOR TYPE %s.\n", type_register;
    }
    else
    {
   	printf "%d %s registers.\n", found_it, type_of_register;
    }
}