/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
#include <stdio.h>
#include <stdint.h>
#include "BJTimer.h"

extern int32_t e_int32_t_add_2(int32_t a, int32_t b);

struct result {
  double frequency_mhz;
  double time_nsecs;
};

void measure_frequency(struct result * res) {
  int i;
  int64_t r;
  ticks t;
  int32_t v = 0;

  r = 500000;
  do {
    r *= 2;
    t = getticks();
    for (i=0; i < r; i++) {
      v += e_int32_t_add_2(3,3);
    }
    t = getticks() - t;
    t = t/1000000.0;
  } while (t < 0.1);

  r = r * 1021;

  res->frequency_mhz = (double)r / (t*1000000.0); /* mhz */
  res->time_nsecs = (t*1000000000.0)/(double)r; /*nanosecs*/
}

int main (int argc, char * argv []) {
  int i;
  int exps = 5;
  double avg_time = 0.0, avg_freq = 0.0;
  struct result res;

  for (i = 0; i < exps; i++) {
    measure_frequency(&res);

    fprintf(stderr, "frequency: %f mhz\n", res.frequency_mhz);
    fprintf(stderr, "add cost: %.16f nsecs\n", res.time_nsecs);

    avg_freq += res.frequency_mhz;
    avg_time += res.time_nsecs;
  }
  printf("<cost_add>\n");
  printf("<frequency_awk> %f </frequency_awk>\n", avg_freq/exps);
  printf("<frequency unit=\"mhz\">%f</frequency>\n", avg_freq/exps);
  printf("<time_awk> %.16f </time_awk>\n", avg_time/exps);
  printf("<time unit=\"nsecs\">%.16f</time>\n", avg_time/exps);
  printf("</cost_add>\n");
  return 0;
}
