#ifndef __UTIL_HEADER__
#define __UTIL_HEADER__

#if defined (__SVR4) && defined (__sun)
#define BUILTIN_STDINT_H
#endif

#ifndef BUILTIN_STDINT_H 
  #include <stdint.h>  
#else 
  #include <inttypes.h>
#endif
/* pace_round - Round to the nearest integer */
int pace_round(double val);

/* util_error - Display error message @err_msg on stderr and exit with error
 * code 2. */
void util_error(const char * err_msg);

/* Length of the c string NULL terminator */
#define LEN_NULL_TERM 1

const char * sym_to_name(const char * sym, const char * syms[], const char * names[], int array_len);


/* Solve two equations to x.
 * 2x + 2y = 3.5
 * 1x + 3y = 4
 */
double solve_equations_to_x(double divisor_eq1, double divisor_eq2, double
    divident_x_eq_1, double divident_x_eq_2, double divident_y_eq_1, double
    divident_y_eq_2, double result_eq_1, double result_eq_2);
/* Solve two equations_to_y. */
double solve_equations_to_y(double divisor_eq1, double divisor_eq2, double
    divident_x_eq_1, double divident_x_eq_2, double divident_y_eq_1, double
    divident_y_eq_2, double result_eq_1, double result_eq_2); 
#endif
