/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "util.h"


int pace_round(double val) {
#if defined (__SVR4) && defined (__sun)
  /* Some version of solaris has no round function */
  return (double)rint(val);
#else
  return (double)round(val);
#endif
}

void util_error(const char * err_msg) {
  fprintf(stderr, err_msg);
  exit(1);
}

const char * sym_to_name(const char * sym, const char * syms[], const char * names[], int array_len) {
  int i = 0;
  for (i=0; i < array_len; i++) {
    if (strcmp(sym, syms[i])==0)
      return names[i];
  }
  return NULL;
}

/* Solve two equations to x.
 * 2x + 2y = 3.5
 * 1x + 3y = 4
 */
#if 0
double solve_equations_to_x(double divisor_eq_1, double divisor_eq_2, 
    double divident_x_eq_1, double divident_x_eq_2, double divident_y_eq_1, 
    double divident_y_eq_2, double result_eq_1, double result_eq_2) {
  return ((((divisor_eq_2/divident_y_eq_2)*result_eq_2) +
          (-1.0*(divisor_eq_1/divident_y_eq_1)*result_eq_1))
          /   
          (divident_x_eq_2-divident_x_eq_1));
}
#endif
double solve_equations_to_x(double divisor_eq_1, double divisor_eq_2, 
    double divident_x_eq_1, double divident_x_eq_2, double divident_y_eq_1, 
    double divident_y_eq_2, double result_eq_1, double result_eq_2) {
  return divident_y_eq_2==0 ? result_eq_2 : divident_y_eq_1==0 ? result_eq_1 : ((((divisor_eq_2/divident_y_eq_2)*result_eq_2) +
          (-1.0*(divisor_eq_1/divident_y_eq_1)*result_eq_1))
          /   
          (divident_x_eq_2-divident_x_eq_1));
}

/* Solve two equations_to_y. */
#if 0
double solve_equations_to_y(double divisor_eq_1, double divisor_eq_2, 
    double divident_x_eq_1, double divident_x_eq_2, double divident_y_eq_1, 
    double divident_y_eq_2, double result_eq_1, double result_eq_2) {
  return ((((divisor_eq_2/divident_x_eq_2)*result_eq_2) +
         (-1.0*(divisor_eq_1/divident_x_eq_1)*result_eq_1)) 
         /
         (1.0/divident_x_eq_2 - 1.0/divident_x_eq_1));
}
#endif
double solve_equations_to_y(double divisor_eq_1, double divisor_eq_2, 
    double divident_x_eq_1, double divident_x_eq_2, double divident_y_eq_1, 
    double divident_y_eq_2, double result_eq_1, double result_eq_2) {
  return divident_x_eq_2==0 ? result_eq_2 : divident_x_eq_1==0 ? result_eq_1 : ((((divisor_eq_2/divident_x_eq_2)*result_eq_2) +
         (-1.0*(divisor_eq_1/divident_x_eq_1)*result_eq_1)) 
         /
        ( divident_y_eq_1==0? (1.0/divident_x_eq_2) : (1.0/divident_x_eq_2 - 1.0/divident_x_eq_1)));
}
