/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
#include "util.h" 
#include <stdlib.h> 
#include <stdio.h> 
#include <time.h> 
#include <math.h> 
extern int32_t f_int32_t(); 
extern int64_t f_int64_t(); 
extern int32_t f_int_div_int32_t(); 
extern int64_t f_int_div_int64_t(); 
extern double g_double_mul(); 
extern float g_float_mul(); 
extern double h_double_mul(); 
extern float h_float_mul(); 
extern double g_double(); 
extern double h_double(); 
extern float g_float(); 
extern float h_float(); 
extern int64_t e_int64_t_add_1(int64_t a1, int64_t a2); 
extern float e_float_div_2(float a1, float a2); 
void set_loop_count(int * loop_count) {
  int cnt = 1000; 
  clock_t t = 1;
  int i = 0;
  while (((double)t)/CLOCKS_PER_SEC < 0.75) {
    cnt *= 2;
    t = clock();
    for (i=0; i < cnt; ++i)
      e_int64_t_add_1(3, 3);
    t = clock() -t ;
  }
  *loop_count = cnt;
}

int main(int argc, char * argv[]) {
  
  int64_t result1; float result2; 
  int64_t a0, a1; float b0, b1; 
  double time1, time2; 
  clock_t start, end; 
  int i=0,r=0; 
  int loop_count = (int) strtol(argv[1], NULL, 10);
  set_loop_count(&loop_count);
 a0 = f_int64_t(); 
 a1 = f_int64_t(); 
  b0 = g_float(); b1 = h_float(); 
  time1 = 0.0; 
  for (r = 0; r < 3; ++r) {
  start = clock(); 
  for (i=0; i < loop_count; i++) { 
    result1 = e_int64_t_add_1(a0, a1); 
  } 
  end = clock(); 
  time1 += ((double)(end-start))/CLOCKS_PER_SEC; 
  } time1 /=3;
  time2 = 0.0;
  for (r = 0; r < 3; ++r) {
  start = clock(); 
  for (i=0; i < loop_count; i++) { 
    result2 = e_float_div_2(b0, b1); 
  } 
  end = clock(); 
  time2 += ((double)(end-start))/CLOCKS_PER_SEC; 
  } time2 /= 3;
  printf("<latency>\n"); 
   printf("<div>\n"); 
   printf("<float>\n"); 
   printf("<value1> div float %d </value1>\n", pace_round(time2/time1));  
  printf("<value type=\"integer\">%d</value>\n", pace_round(time2/time1));  
  printf("<debug>\n"); 
  printf("<time1><value type=\"double\">%f</value></time1>\n", time1); 
  printf("<time2><value type=\"double\">%f</value></time2>\n", time2); 
  printf("</debug>\n"); 
  printf("</float>\n"); 
   printf("</div>\n"); 
   printf("</latency>\n"); 
   return 0; }
