/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
#include "util.h"
#include <float.h>

#ifndef BUILTIN_STDINT_H
#include <stdint.h>
#else 
#include <inttypes.h>
#endif

#if 0
double g() {
  return (double) (2.0);
}

double h() {
  return (double) (1.0);
}
#else
float g_float_mul() {
  return (float) 1.0E+0;/* INT64_C(0x7fefffffffffffff); INT64_C(0x7fefffffffffffff)*/
}

float h_float_mul() {
  return (float) 1.0E+0;/* INT64_C(0x3ff0000000000000); INT64_C(0x3ff0000000000000);*/
}

double g_double_mul() {
  return (double) 1.0E+0;/* INT64_C(0x7fefffffffffffff); INT64_C(0x7fefffffffffffff)*/
}

double h_double_mul() {
  return (double) 1.0E+0;/* INT64_C(0x3ff0000000000000); INT64_C(0x3ff0000000000000);*/
}


double g_double() {
  return (double) 9.218868E+18;/* INT64_C(0x7fefffffffffffff); INT64_C(0x7fefffffffffffff)*/
}

double h_double() {
  return (double) 4.607182E+18;/* INT64_C(0x3ff0000000000000); INT64_C(0x3ff0000000000000);*/
}

float g_float() {
  return (float) 9.218868E-9;/*INT64_C(0x7fefffffffffffff)*/
  //return (float) 9.218868134E-6;/*INT64_C(0x7fefffffffffffff)*/
}

float h_float() {
  return (float) 4.607182E-9; /*INT64_C(0x3ff0000000000000);*/
  //return (float) 4.607182451E-6; /*INT64_C(0x3ff0000000000000);*/
}
#endif

#if 0
/* Use this for integer division, seems to show timing close to maximum
 * latency*/

int f() {
  return INT32_C(0xAAAAAAAA);
}
int f2() {
  return INT32_C(0xAAAAAAAA);
}
#else

int64_t f_int_div_int64_t() {
  return INT64_C(0xAAAAAAAAAAAAAAAA);
}

int32_t f_int_div_int32_t() {
  return INT32_C(0xAAAAAAAA);
}

int32_t f_int32_t() {
   return INT32_C(3);
}

int64_t f_int64_t() {
  return INT64_C(3);
}

int f2() {
  return INT32_C(3);
}
#endif


void strreverse(char* begin, char* end) {
    
    char aux;
      
      while(end>begin)
          
            aux=*end, *end--=*begin, *begin++=aux;
        
}

void itoa(int64_t value, char* str, int base) {

  static char num[] = "0123456789abcdefghijklmnopqrstuvwxyz";

  char* wstr=str;

  int64_t sign;


  if (base<2 || base>35){ *wstr='\0'; return; }


  if ((sign=value) < 0) value = -value;


  do *wstr++ = num[value%base]; while(value/=base);

  if(sign<0) *wstr++='-';

  *wstr='\0';



  strreverse(str,wstr-1);

}

void doubletobit(double value, char* str) {
  double * dp;
  int64_t val;
  dp = (double*)&val;
  *dp = value;
  itoa(val, str, 2);
}


