#!/bin/bash

check () {
 NUMBER=$1
 CHECK=`echo $NUMBER | grep " "`
 if [ "$CHECK" != "" ]; then
     echo "ERROR: Space detected in \"$NUMBER\""
 fi
 CHECK=`echo $NUMBER | grep "-"`
 if [ "$CHECK" != "" ]; then
     echo "ERROR: Not a positive integer $NUMBER"
 fi
}


ADD_VALUE32I=`cat pace_rcdb | grep op_data.op_kind.latency.bits.32-bit.op_type.integer.add_value | awk 'END {print $2}'`
check $ADD_VALUE32I
SUB_VALUE32I=`cat pace_rcdb | grep op_data.op_kind.latency.bits.32-bit.op_type.integer.sub_value | awk 'END {print $2}'`
check $SUB_VALUE32I
MULT_VALUE32I=`cat pace_rcdb | grep op_data.op_kind.latency.bits.32-bit.op_type.integer.mult_value | awk 'END {print $2}'`
check $MULT_VALUE32I
DIV_VALUE32I=`cat pace_rcdb | grep op_data.op_kind.latency.bits.32-bit.op_type.integer.div_value | awk 'END {print $2}'`
check $DIV_VALUE32I


ADD_VALUE64I=`cat pace_rcdb | grep op_data.op_kind.latency.bits.64-bit.op_type.integer.add_value | awk 'END {print $2}'`
check $ADD_VALUE64I
SUB_VALUE64I=`cat pace_rcdb | grep op_data.op_kind.latency.bits.64-bit.op_type.integer.sub_value | awk 'END {print $2}'`
check $SUB_VALUE64I
MULT_VALUE64I=`cat pace_rcdb | grep op_data.op_kind.latency.bits.64-bit.op_type.integer.mult_value | awk 'END {print $2}'`
check $MULT_VALUE64I
DIV_VALUE64I=`cat pace_rcdb | grep op_data.op_kind.latency.bits.64-bit.op_type.integer.div_value | awk 'END {print $2}'`
check $DIV_VALUE64I


ADD_VALUE32F=`cat pace_rcdb | grep op_data.op_kind.latency.bits.32-bit.op_type.float.add_value | awk 'END {print $2}'`
check $ADD_VALUE32F
SUB_VALUE32F=`cat pace_rcdb | grep op_data.op_kind.latency.bits.32-bit.op_type.float.sub_value | awk 'END {print $2}'`
check $SUB_VALUE32F
MULT_VALUE32F=`cat pace_rcdb | grep op_data.op_kind.latency.bits.32-bit.op_type.float.mult_value | awk 'END {print $2}'`
check $MULT_VALUE32F
DIV_VALUE32F=`cat pace_rcdb | grep op_data.op_kind.latency.bits.32-bit.op_type.float.div_value | awk 'END {print $2}'`
check $DIV_VALUE32F


ADD_VALUE64F=`cat pace_rcdb | grep op_data.op_kind.latency.bits.64-bit.op_type.float.add_value | awk 'END {print $2}'`
check $ADD_VALUE64F
SUB_VALUE64F=`cat pace_rcdb | grep op_data.op_kind.latency.bits.64-bit.op_type.float.sub_value | awk 'END {print $2}'`
check $SUB_VALUE64F
MULT_VALUE64F=`cat pace_rcdb | grep op_data.op_kind.latency.bits.64-bit.op_type.float.mult_value | awk 'END {print $2}'`
check $MULT_VALUE64F
DIV_VALUE64F=`cat pace_rcdb | grep op_data.op_kind.latency.bits.64-bit.op_type.float.div_value | awk 'END {print $2}'`
check $DIV_VALUE64F


ADD_VALUE32I_PAR=`cat pace_rcdb | grep op_data.op_kind.parallel_ops.bits.32-bit.op_type.integer.add_value | awk 'END {print $2}'`
check $ADD_VALUE32I_PAR
SUB_VALUE32I_PAR=`cat pace_rcdb | grep op_data.op_kind.parallel_ops.bits.32-bit.op_type.integer.sub_value | awk 'END {print $2}'`
check $SUB_VALUE32I_PAR
MULT_VALUE32I_PAR=`cat pace_rcdb | grep op_data.op_kind.parallel_ops.bits.32-bit.op_type.integer.mult_value | awk 'END {print $2}'`
check $MULT_VALUE32I_PAR
DIV_VALUE32I_PAR=`cat pace_rcdb | grep op_data.op_kind.parallel_ops.bits.32-bit.op_type.integer.div_value | awk 'END {print $2}'`
check $DIV_VALUE32I_PAR


ADD_VALUE64I_PAR=`cat pace_rcdb | grep op_data.op_kind.parallel_ops.bits.64-bit.op_type.integer.add_value | awk 'END {print $2}'`
check $ADD_VALUE64I_PAR
SUB_VALUE64I_PAR=`cat pace_rcdb | grep op_data.op_kind.parallel_ops.bits.64-bit.op_type.integer.sub_value | awk 'END {print $2}'`
check $SUB_VALUE64I_PAR
MULT_VALUE64I_PAR=`cat pace_rcdb | grep op_data.op_kind.parallel_ops.bits.64-bit.op_type.integer.mult_value | awk 'END {print $2}'`
check $MULT_VALUE64I_PAR
DIV_VALUE64I_PAR=`cat pace_rcdb | grep op_data.op_kind.parallel_ops.bits.64-bit.op_type.integer.div_value | awk 'END {print $2}'`
check $DIV_VALUE64I_PAR


ADD_VALUE32F_PAR=`cat pace_rcdb | grep op_data.op_kind.parallel_ops.bits.32-bit.op_type.float.add_value | awk 'END {print $2}'`
check $ADD_VALUE32F_PAR
SUB_VALUE32F_PAR=`cat pace_rcdb | grep op_data.op_kind.parallel_ops.bits.32-bit.op_type.float.sub_value | awk 'END {print $2}'`
check $SUB_VALUE32F_PAR
MULT_VALUE32F_PAR=`cat pace_rcdb | grep op_data.op_kind.parallel_ops.bits.32-bit.op_type.float.mult_value | awk 'END {print $2}'`
check $MULT_VALUE32F_PAR
DIV_VALUE32F_PAR=`cat pace_rcdb | grep op_data.op_kind.parallel_ops.bits.32-bit.op_type.float.div_value | awk 'END {print $2}'`
check $DIV_VALUE32F_PAR


ADD_VALUE64F_PAR=`cat pace_rcdb | grep op_data.op_kind.parallel_ops.bits.64-bit.op_type.float.add_value | awk 'END {print $2}'`
check $ADD_VALUE64F_PAR
SUB_VALUE64F_PAR=`cat pace_rcdb | grep op_data.op_kind.parallel_ops.bits.64-bit.op_type.float.sub_value | awk 'END {print $2}'`
check $SUB_VALUE64F_PAR
MULT_VALUE64F_PAR=`cat pace_rcdb | grep op_data.op_kind.parallel_ops.bits.64-bit.op_type.float.mult_value | awk 'END {print $2}'`
check $MULT_VALUE64F_PAR
DIV_VALUE64F_PAR=`cat pace_rcdb | grep op_data.op_kind.parallel_ops.bits.64-bit.op_type.float.div_value | awk 'END {print $2}'`
check $DIV_VALUE64F_PAR


LIVE_VALUES_I32=`cat pace_rcdb | grep live_values.bits.32-bit.live_type.integer.number | awk 'END {print $2}'`
check $LIVE_VALUES_I32
LIVE_VALUES_I64=`cat pace_rcdb | grep live_values.bits.64-bit.live_type.integer.number | awk 'END {print $2}'`
check $LIVE_VALUES_I64
LIVE_VALUES_F32=`cat pace_rcdb | grep live_values.bits.32-bit.live_type.float.number | awk 'END {print $2}'`
check $LIVE_VALUES_F32
LIVE_VALUES_F64=`cat pace_rcdb | grep live_values.bits.64-bit.live_type.float.number | awk 'END {print $2}'`
check $LIVE_VALUES_F64     

INTEGER_CONTEXTS=`cat pace_rcdb | grep parallel_contexts.integer_context | awk 'END {print $2}'`
check $INTEGER_CONTEXTS
FLOAT_CONTEXT=`cat pace_rcdb | grep parallel_contexts.float_context   | awk 'END {print $2}'`
check $FLOAT_CONTEXT
MEMORY_INTENSIVE_CONTEXT=`cat pace_rcdb | grep parallel_contexts.memory_context | awk 'END {print $2}'`
check $MEMORY_INTENSIVE_CONTEXT

echo " <char:characterization xmlns:char=\"urn:characterization.aace\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"urn:characterization.aace AACEcharMay26.xsd\"> "
echo " <version>$VERSION</version>"
echo "  <system_id>"
echo "		<short_name>$SHORT_NAME</short_name>"
echo "		<ip_address><a href=\"http://$IP_ADDRESS\">$IP_ADDRESS</a></ip_address>"
echo "		<location>$LOCATION</location>"

echo "  </system_id>"

for LEVEL in {1..200}
 do
   CASHLEVEL_DI=`cat pace_rcdb | grep cache.kind.data.kind.instruction.level.$LEVEL | awk 'END {print $2}'`
   if [ -n "$CASHLEVEL_DI" ]
   then
	
	 PAGEORLINE_SIZE=`cat pace_rcdb | grep cache.kind.data.kind.instruction.level.$LEVEL.pageorline_size | awk 'END {print $2}'`
	 check $PAGEORLINE_SIZE
	 TOTAL_SIZE=`cat pace_rcdb | grep cache.kind.data.kind.instruction.level.$LEVEL.total_size | awk 'END {print $2}'`
	 check $TOTAL_SIZE
	 ASSOCIATIVITY=`cat pace_rcdb | grep cache.kind.data.kind.instruction.level.$LEVEL.associativity | awk 'END {print $2}'`
	 check $ASSOCIATIVITY
	 LOAD_COST=`cat pace_rcdb | grep cache.kind.data.kind.instruction.level.$LEVEL.load_cost | awk 'END {print $2}'`
	 check $LOAD_COST
	 echo " <cache>"
	 echo "		<kind>data</kind>"
	 echo "		<kind>instruction</kind>"
	 echo "		<level>$LEVEL</level>"
	 echo "		<pageorline_size>$PAGEORLINE_SIZE</pageorline_size>"
	 echo "		<total_size>$TOTAL_SIZE</total_size>"
	 if [ $LEVEL -eq 1 ]
	 then
	   echo "		<associativity>$ASSOCIATIVITY</associativity>"
	 fi
	 echo "		<load_cost>$LOAD_COST</load_cost>"
	 echo "	</cache>"
	 
	 
   fi
   
   CASHLEVEL_D=`cat pace_rcdb | grep cache.kind.data.level.$LEVEL | awk 'END {print $2}'`
   if [ -n "$CASHLEVEL_D" ]
   then
	
	 PAGEORLINE_SIZE=`cat pace_rcdb | grep cache.kind.data.level.$LEVEL.linesize | awk 'END {print $2}'`
	 check $PAGEORLINE_SIZE
	 TOTAL_SIZE=`cat pace_rcdb | grep cache.kind.data.level.$LEVEL.total_size | awk 'END {print $2}'`
	 check $TOTAL_SIZE
	 ASSOCIATIVITY=`cat pace_rcdb | grep cache.kind.data.level.$LEVEL.associativity | awk 'END {print $2}'`
	 check $ASSOCIATIVITY
	 LOAD_COST=`cat pace_rcdb | grep cache.kind.data.level.$LEVEL.load_cost | awk 'END {print $2}'`
	 check $LOAD_COST
	 echo " <cache>"
	 echo "		<kind>data</kind>"
	 echo "		<level>$LEVEL</level>"
	 echo "		<pageorline_size>$PAGEORLINE_SIZE</pageorline_size>"
	 echo "		<total_size>$TOTAL_SIZE</total_size>"
	 if [ $LEVEL -eq 1 ]
	 then
	     echo "		<associativity>$ASSOCIATIVITY</associativity>"
	 fi
	 echo "		<load_cost>$LOAD_COST</load_cost>"
	 echo "	</cache>"
	 
   fi
   
   CASHLEVEL_I=`cat pace_rcdb | grep cache.kind.instruction.level.$LEVEL | awk 'END {print $2}'`
   if [ -n "$CASHLEVEL_I" ]
   then
	
	 PAGEORLINE_SIZE=`cat pace_rcdb | grep cache.kind.instruction.level.$LEVEL.pageorline_size | awk 'END {print $2}'`
	 check $PAGEORLINE_SIZE
	 TOTAL_SIZE=`cat pace_rcdb | grep cache.kind.instruction.level.$LEVEL.total_size | awk 'END {print $2}'`
	 check $TOTAL_SIZE
	 ASSOCIATIVITY=`cat pace_rcdb | grep cache.kind.instruction.level.$LEVEL.associativity | awk 'END {print $2}'`
	 check $ASSOCIATIVITY
	 LOAD_COST=`cat pace_rcdb | grep cache.kind.instruction.level.$LEVEL.load_cost | awk 'END {print $2}'`
	 check $LOAD_COST
	 echo " <cache>"
	 echo "		<kind>instruction</kind>"
	 echo "		<level>$LEVEL</level>"
	 echo "		<pageorline_size>$PAGEORLINE_SIZE</pageorline_size>"
	 echo "		<total_size>$TOTAL_SIZE</total_size>"
	 if [ $LEVEL -eq 1 ]
	 then
	 echo "		<associativity>$ASSOCIATIVITY</associativity>"
	 fi
	 echo "		<load_cost>$LOAD_COST</load_cost>"
	 echo "	</cache>"
	 
   fi
   
   CASHLEVEL_TLB=`cat pace_rcdb | grep cache.kind.TLB.level.$LEVEL | awk 'END {print $2}'`
   if [ -n "$CASHLEVEL_TLB" ]
   then
	
	 PAGEORLINE_SIZE=`cat pace_rcdb | grep cache.kind.TLB.level.$LEVEL.pageorline_size | awk 'END {print $2}'`
	 check $PAGEORLINE_SIZE
	 TOTAL_SIZE=`cat pace_rcdb | grep cache.kind.TLB.level.$LEVEL.total_size | awk 'END {print $2}'`
	 check $TOTAL_SIZE
	 ASSOCIATIVITY=`cat pace_rcdb | grep cache.kind.TLB.level.$LEVEL.associativity | awk 'END {print $2}'`
	 check $ASSOCIATIVITY
   echo " <cache>"
	 echo "		<kind>TLB</kind>"
	 echo "		<level>$LEVEL</level>"
	 echo "		<pageorline_size>$PAGEORLINE_SIZE</pageorline_size>"
	 echo "		<total_size>$TOTAL_SIZE</total_size>"
   echo "		<associativity>$ASSOCIATIVITY</associativity>"
   echo "	</cache>"
	 
   fi

   
 done


echo "	<op_data>"
echo "		<op_kind>latency</op_kind>"
echo "		<bits>32-bit</bits>"
echo "		<op_type>integer</op_type>"
echo "		<add_value>$ADD_VALUE32I</add_value>"
echo "		<sub_value>$SUB_VALUE32I</sub_value>"
echo "		<mult_value>$MULT_VALUE32I</mult_value>"
echo "		<div_value>$DIV_VALUE32I</div_value>"
echo "	</op_data>"

echo "	<op_data>"
echo "		<op_kind>latency</op_kind>"
echo "		<bits>64-bit</bits>"
echo "		<op_type>integer</op_type>"
echo "		<add_value>$ADD_VALUE64I</add_value>"
echo "		<sub_value>$SUB_VALUE64I</sub_value>"
echo "		<mult_value>$MULT_VALUE64I</mult_value>"
echo "		<div_value>$DIV_VALUE64I</div_value>"
echo "	</op_data>"

echo "	<op_data>"
echo "		<op_kind>latency</op_kind>"
echo "		<bits>32-bit</bits>"
echo "		<op_type>float</op_type>"
echo "		<add_value>$ADD_VALUE32F</add_value>"
echo "		<sub_value>$SUB_VALUE32F</sub_value>"
echo "		<mult_value>$MULT_VALUE32F</mult_value>"
echo "		<div_value>$DIV_VALUE32F</div_value>"
echo "	</op_data>"

echo "	<op_data>"
echo "		<op_kind>latency</op_kind>"
echo "		<bits>64-bit</bits>"
echo "		<op_type>float</op_type>"
echo "		<add_value>$ADD_VALUE64F</add_value>"
echo "		<sub_value>$SUB_VALUE64F</sub_value>"
echo "		<mult_value>$MULT_VALUE64F</mult_value>"
echo "		<div_value>$DIV_VALUE64F</div_value>"
echo "	</op_data>"


echo "	<op_data>"
echo "		<op_kind>parallel_ops</op_kind>"
echo "		<bits>32-bit</bits>"
echo "		<op_type>integer</op_type>"
echo "		<add_value>$ADD_VALUE32I_PAR</add_value>"
echo "		<sub_value>$SUB_VALUE32I_PAR</sub_value>"
echo "		<mult_value>$MULT_VALUE32I_PAR</mult_value>"
echo "		<div_value>$DIV_VALUE32I_PAR</div_value>"
echo "	</op_data>"

echo "	<op_data>"
echo "		<op_kind>parallel_ops</op_kind>"
echo "		<bits>64-bit</bits>"
echo "		<op_type>integer</op_type>"
echo "		<add_value>$ADD_VALUE64I_PAR</add_value>"
echo "		<sub_value>$SUB_VALUE64I_PAR</sub_value>"
echo "		<mult_value>$MULT_VALUE64I_PAR</mult_value>"
echo "		<div_value>$DIV_VALUE64I_PAR</div_value>"
echo "	</op_data>"

echo "	<op_data>"
echo "		<op_kind>parallel_ops</op_kind>"
echo "		<bits>32-bit</bits>"
echo "		<op_type>float</op_type>"
echo "		<add_value>$ADD_VALUE32F_PAR</add_value>"
echo "		<sub_value>$SUB_VALUE32F_PAR</sub_value>"
echo "		<mult_value>$MULT_VALUE32F_PAR</mult_value>"
echo "		<div_value>$DIV_VALUE32F_PAR</div_value>"
echo "	</op_data>"

echo "	<op_data>"
echo "		<op_kind>parallel_ops</op_kind>"
echo "		<bits>64-bit</bits>"
echo "		<op_type>float</op_type>"
echo "		<add_value>$ADD_VALUE64F_PAR</add_value>"
echo "		<sub_value>$SUB_VALUE64F_PAR</sub_value>"
echo "		<mult_value>$MULT_VALUE64F_PAR</mult_value>"
echo "		<div_value>$DIV_VALUE64F_PAR</div_value>"
echo "	</op_data>"

for ARGUMENTS in {0..200}
 do
   FUNCTION_CALL_COST=`cat pace_rcdb | grep function_call_cost.arguments.$ARGUMENTS | awk 'END {print $2}'`
   if [ -n "$FUNCTION_CALL_COST" ]
   then
    
	 COST=`cat pace_rcdb | grep function_call_cost.arguments.$ARGUMENTS.cost | awk 'END {print $2}'`
	 check $COST
echo " <function_call_cost>"
echo "		<arguments>$ARGUMENTS</arguments>"
echo "		<cost>$COST</cost>"
echo "	</function_call_cost>"
	 	 
   fi
done

echo "	<live_values>"
echo "		<live_type>integer</live_type>"
echo "		<bits>32-bit</bits>"
echo "		<number>$LIVE_VALUES_I32</number>"
echo "	</live_values>"

echo "	<live_values>"
echo "		<live_type>integer</live_type>"
echo "		<bits>64-bit</bits>"
echo "		<number>$LIVE_VALUES_I64</number>"
echo "	</live_values>"

echo "	<live_values>"
echo "		<live_type>float</live_type>"
echo "		<bits>32-bit</bits>"
echo "		<number>$LIVE_VALUES_F32</number>"
echo "	</live_values>"

echo "	<live_values>"
echo "		<live_type>float</live_type>"
echo "		<bits>64-bit</bits>"
echo "		<number>$LIVE_VALUES_F64</number>"
echo "	</live_values>"


echo "  <parallel_contexts>"
echo "		<integer_context>$INTEGER_CONTEXTS</integer_context>"
echo "		<float_context>$FLOAT_CONTEXT</float_context>"
echo "		<memory_intensive_context>$MEMORY_INTENSIVE_CONTEXT</memory_intensive_context>"
echo "  </parallel_contexts>"
echo " </char:characterization>"


