/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
/* PACE Project, Rice University
 *
 * This code measures the parameters of the cache memory system.
 * 
 * First, it determines L1 size, associativity, and line size.
 * It uses size to determine associativity.
 *
 *
 */

#include "AddCost.h"
#include "BlackJackTimer.h"
#include "../Lib/pace_rc_memlib.h"

void exit( int x );
int errno;

char * TimeStamp();
char HostName[128];

double AddCost();

static void DieWithMessage(char *currArg, int argNumber)
{
  fprintf(stderr,"Did not understand argument '%s' (%d).\n",
	  currArg,argNumber);
  fprintf(stderr,"Valid arguments are:\n");
  fprintf(stderr,"\t-d \tGenerate detailed output into file 'CacheData'.\n");
  fprintf(stderr,"\t-g \tActivate internal debugging checks.\n");
  fprintf(stderr,"\t-l <name> \tUse <name> for log file.\n");
  fprintf(stderr,"\t-p \tDon't precondition the data.\n");
  fprintf(stderr,"\t-v \tPrint results (& debug info) incrementally.\n");
  exit(-1);  
}

int main(int argc, char *argv[])
{
  int i, j, arg, argNumber;
  char *currArg, *LogFileName;
  double AddCostInNsecs;

  Verbose   = 0;
  Debug     = 0;
  HeartBeat = 1;

  LogFileName = "./Log";

  /* Parse the command line parameters */
  for (argNumber = 1; argNumber < argc; argNumber++)
  {
    currArg = argv[argNumber];

    if (*currArg == '-')
    {
      currArg++; 
      while (*currArg != '\0')
      {
	switch(*currArg)
        {
	  case 'g':
	    Debug++;
	    break;
  	  case 'h':
	    HeartBeat++;
	    break;
	  case 'l':
	    argNumber++;
	    LogFileName = argv[argNumber];
	    break;
	  case 'v':
            Verbose++;
	    break;
	  default:
	    DieWithMessage(currArg,argNumber);
	}
	currArg++;
      }
    }
  }

  /* Set up the Log File */
  fprintf(stderr,"Log File Name is '%s'.\n",LogFileName);

  LogFile = fopen(LogFileName,"w");
  if (LogFile == NULL) /* cannot use abort() since it writes 'LogFile' */
  {
    fprintf(stderr,"fopen() of 'CacheTestLog' failed\n");
    exit(-2);
  }

  (void) SetupAndMark( LogFile, "LogFile");
  fprintf(LogFile,"\"AddCost Computation\"\n");

  /* test for the presence of the environment variable for temp results */
  (void) TestEnvVar();  /* dies if environment variable is missing */

  /* Some initializations */
  if (HeartBeat)
    fprintf(stderr,"Providing HeartBeat @ Level %d.\n",HeartBeat);
  
  AddCostInNsecs = AddCost();
  DWriteResult("AddCost",AddCostInNsecs);
}
