#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <math.h>
#include "../Lib/pace_rc_memlib.h"


#define TESTNAME "MEML"
#define TESTSUFFIX "c"

#define MIN_TICKS   1000
#define TRIALS_FOR_MIN  50
#define LOWERBOUNDINBYTES  4096
#define UPPERBOUNDINBYTES  64*1024*1024
#define MAX_TESTS_PER_RUN  128
#define MAX_LEVELS  50

#define CorDThreshold  1.5

#define log2(x) ((int) (log((double) x)/log(2.0)))


FILE *LogFile,  *DataFile;

/* Control flags */
int Verbose;        /* controls level of comments in LogFile */
int HeartBeat;      /* controls level of heart beats to stderr */
int Data;           /* controls generation of CSV data file */
int Debug;          /* controls level of debugging detail (to stderr) */

/* Shared Global Data items ... initialized in main() */
int    UnitSize;    /* size of an int, since tests work on C ints */
double TimerTick;   /* Timer resolution, expressed as a double    */
double MinTime;     /* Minimum time for any test */
int    BigInt;      /* a very large integer */

int    GlobalTrash;  /* to defeat dead code elimination */

int PageSize;
double AddCost;

/* Prototypes for functions */ 

double  FindTimerTick();
int     FindBigInt();

void   Analyze( int s[], double t[], int c, double r );
void   FindNA( int size, int blocksize, int stride, struct AccessCount *NA );
double  BCTest( int size, int blocksize, int stride, struct AccessCount NA );

/* Prototype for functions from math library */
double fmax(double x, double y);
double log(double x);


#define LogConfirm  1
#define CorDConfirm 2
