/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
#include "MemTest.h"
#include "BlackJackTimer.h"

/* TimePerm
 *
 * Runs a permutation and returns elapsed time
 *
 * PARAMETERS: NAccesses
 *
 * RETURNS:    Elapsed time, in microseconds, as a double
 *
 */

double TimePerm( int a[], int sp, struct AccessCount n );

/* AssocTest( Size, Ways )
 *
 * Constructs an access pattern in which all the references map to a single
 * way in cache.  Uses TimePerm to run the pattern and time it.
 *
 * PARAMETERS:  Size, Ways 
 *
 * RETURNS:     An elapsed time, in microseconds, as a double
 *
 */

static void **Array = NULL;


static double AssocTest( int Size, int Ways, struct AccessCount NA )
{
  int i, j, Index[Ways], Spacing;
  double result;
  void **OldArray = (void**) NULL;

  if ((HeartBeat > 1) || Debug)
    fprintf(stderr,"\nTesting for Associativity %d ways @ %s b: ",
	    Ways,PrintNum(Size*UnitSize));

  /* Allocate and Initialize an Array */
  OldArray = Array;
  Array = (void **) PACE_AllocMem( Ways * Size * sizeof(void**) );
  if (OldArray != (void **) NULL)
    PACE_FreeMem((void *) OldArray);

  /* Build the permutation */
  if ((Size % Ways) == 0)
  {
    Spacing = Size / Ways;
  }
  else
  {
    i = Ways - 2;
    while((Size % i) != 0)
    {
      i -= 2;
    }
    Spacing = Size / i;
  }

  if (Debug)
    fprintf(stderr,"Assoc( %s, %d ) using spacing of %s.\n", 
	    PrintNum(Size*UnitSize),Ways,PrintNum(Spacing));

  for (i=0; i<Ways; i++)
  {
    Index[i] = i * Spacing;
  }

  Shuffle( Index, Ways );

  for (i=1; i<Ways; i++)
  {
    Array[Index[i]] = &Array[Index[i-1]];
    Array[Index[i]+1] = (void**) 0;
    if (Debug>1)
       fprintf(stderr,"\nA[%d] <- %d",Index[i],Index[i-1]);
  }
  Array[Index[0]] = &Array[Index[Ways-1]];

  if (Debug>1)
    fprintf(stderr,"\nA[%d] <- %d\n",Index[0],Index[Ways-1]);

  /* Run the test */
  result = TimePermPtr(Array,Index[0],NA);

  if (HeartBeat > 1)
    fprintf(stderr,"%s usec\n",PrintDNum(result));

  return result;
}

int AssocTrial ( int Size, int LineSize )
{
  int i, j, nTests, result;
  double Trial;
  struct AccessCount NA; 

  int Ways[32];
  double Times[32];

  if (HeartBeat>1)
    fprintf(stderr,"Associativity Test @ %s b.\n",PrintNum(Size*UnitSize));

  NA.outer = 1;
  NA.inner = 1000000;

  Trial = AssocTest( Size, 2, NA );
  while (Trial < MinTime )
  {
    if (NA.inner < BigInt)
      NA.inner = NA.inner + NA.inner;
    else
      NA.outer++;

    Trial = AssocTest( Size, 2, NA );
  }
  fprintf(LogFile,
	  "\"Associativity test base time for (%s ; %s) accesses is %f.\"\n",
	  PrintNum(NA.outer),PrintNum(NA.inner),Trial);

  for (i=0;i<17;i++)
  {
    Ways[i]  = 2*(i+1);
  }

  nTests = 16;

  for (j=0; j<TRIALS_FOR_MIN; j++)
  {
    for (i=0;i<nTests;i++)
    {
      Trial = AssocTest( Size, Ways[i], NA );
      if (j==0)
	Times[i] = Trial;
      else if (Trial < Times[i])
	Times[i] = Trial;
    }
  }

  if (Array != (void**) NULL)
  {
    PACE_FreeMem(Array);
    Array = (void **) NULL;
  }

  fprintf(LogFile,"Ways\tTime\n");
  for (i=0;i<nTests;i++)
    fprintf(LogFile,"%02d\t%.1f\n",Ways[i],Times[i]);

  result = SharpRiseTest( Ways, Times, nTests, 0.10 );
  return result;
}

