/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
/* Code stolen from Reconcile.c */
#include "MemTest.h"

char buf[256];

static int Close( int i, int j, double frac )
{
  int result;
  double x, y, ratio;

  x = (double) i;
  y = (double) j;

  if (x < y)
    ratio = 1.0 - (x / y);
  else
    ratio = 1.0 - (y / x);

  if (ratio <= frac) /* linear half of a power of 2 */
    result = 1;
  else 
    result = 0;

  return result;
}

void MiniReconcile()
{
  int i, j, NotDone, level, spots;
  int Spot1, Spot2, LevelNum,ThisLevel;
  int Results[4][10];

  char buf[32], *p;

  fprintf(LogFile,"--------------------------------\n");
  fprintf(LogFile,"\nL%d TLB Values\n",level);

  level   = 0;
  NotDone = 1;
  while(NotDone)
  {
    NotDone = 0;
    for (spots=0;spots<4;spots++)
    {
      sprintf(buf,"TLBI%02dS-%dSpot",level+1,spots+1);
      j = ReadResultSoft(buf);
      if (HeartBeat > 1)
	fprintf(stderr,"Level %d, %d Spots -> '%s'\t-> %d.\n",
		level+1,spots+1,buf,j);
      Results[level][spots] = j;

      if (Results[level][spots] > 0)
      {
	NotDone = 1;
      }
    }
    level++;
    if (level > 9)
    {
      fprintf(stderr,"MiniReconcile: Too many levels detected\n");
      NotDone = 0;
    }
  }
  fprintf(LogFile,"\nResults:\n\n%5s %10s %10s %10s %10s\n","Level",
	  "1 Spot","2 Spot","3 Spot","4 Spot");
  for(i=0;i<level;i++)
  {
    fprintf(LogFile,"%5d %10s %10s %10s %10s\n",i,
	    PrintNum(Results[i][0]),PrintNum(Results[i][1]),
	    PrintNum(Results[i][2]),PrintNum(Results[i][3]));
  }

  /* Now, pick out values from the 1-spot test that are confirmed by
   * the 2-spot test.  Ignore the 3-spot & 4-spot; they will require
   * linesize and capacity on contained caches to interpret 
   */

  Spot1 = 0;
  Spot2 = 0;
  LevelNum  = 1;
  ThisLevel = -1;
  NotDone = 1;
  while(NotDone)
  {
    NotDone = 0;
    ThisLevel = Results[Spot1][0];
    if (ThisLevel != -1)
    {
      for (i=0;i<level;i++)
      {
	if (Close(ThisLevel,Results[i][1],0.25))
	{
          fprintf(LogFile,
		  "L%d confirmed with 1-Spot %10s (%d) and 2-Spot %10s (%d)\n",
		  LevelNum,PrintNum(ThisLevel),Spot1,
		  PrintNum(Results[i][1]),i);
	  /* Write the confirmed result into the TLBI file for Reconcile */
	  sprintf(buf,"TLBI%02dS",LevelNum);
	  WriteResult(buf,ThisLevel);

	  /* When we report other TLB Characteristics, this is the place
           * where we will need to copy the data from the 1-Spot files to
           * the TLBI file
           */
	  LevelNum++;
	}
      }
      Spot1++;
      if (Spot1 < level)
	NotDone = 1;
    }
  }
}

