#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <math.h>

#define MIN_TICKS   1000
#define LOWERBOUNDINWORDS  512
#define UPPERBOUNDINWORDS  8*1024*1024
#define MAX_TESTS_PER_RUN  256
#define MAX_LEVELS  50

#define CorDThreshold  1.5

#define log2(x) ((int) (log((double) x)/log(2.0)))

struct AccessCount {
  int outer;
  int inner;
};

FILE *LogFile;

/* Control flags */
int Verbose;        /* controls level of comments in LogFile */
int HeartBeat;      /* controls level of heart beats to stderr */
int Data;           /* controls generation of CSV data file */
int Debug;          /* controls level of debugging detail (to stderr) */

/* Shared Global Data items ... initialized in main() */
int    UnitSize;    /* size of an element in MemArray */
double TimerTick;   /* Timer resolution, expressed as a double    */
double MinTime;     /* Minimum time for any test */
int    BigInt;      /* a very large integer */

int    GlobalTrash;  /* to defeat dead code elimination */

int *MemArray;

/* Prototypes for functions */ 
double  FindTimerTick();
int     FindBigInt();
char *  PrintNum( int s );
char *  PrintDNum( double d );

void   Analyze( int s[], double t[], int c, double r );
void   FindNA( int size, int blocksize, int stride, struct AccessCount *NA );
double  BCTest( int size, int blocksize, int stride, struct AccessCount NA );

/* Prototype for functions from math library */
double fmax(double x, double y);
double log(double x);

/* and local implementations */
int Max( int i, int j);
int Abs( int i);

struct MemLevel {
  int Level;
  int Size;
  int SizeConfirm;
  int Associativity;
  int Granularity;
  int RelativeCost;
  double AccessCost;
};

struct MemLevel MemData[MAX_LEVELS];
int NextMemLevel;
int PageSize;

#define LogConfirm  1
#define CorDConfirm 2
