/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
/*
 *  PACE Project, Rice University
 *
 *  Functions to report into the PACE_RCDB directory
 *
 */

#include <stdio.h>
#include <stdlib.h>

static char *ENV_VAR = "PACE_TEMP";

static int DontHaveDir = 1;
static char* DirName;

void TestEnvVar( )
{
  if (DontHaveDir)
    DirName = getenv(ENV_VAR);
    if (DirName == NULL)
    {
      fprintf(stderr,"Environment variable \"%s\" is not set.\n",ENV_VAR);
      exit(-1);
    }
    DontHaveDir = 0;
}

void WriteResult( char *name, int value )
{
  char buffer[256];
  int  retval;
  FILE *OutFile;

  if (DontHaveDir)
  {
    TestEnvVar();
    DontHaveDir = 0;
  }
  sprintf(buffer,"%s/%s",DirName,name);

  OutFile = fopen(buffer,"w");
  if (OutFile == NULL)
  {
    fprintf(stderr,"Cannot open file \"%s\" for output.\n",buffer);
    exit(-1);
  }
  fprintf(OutFile,"%d",value);
  retval = fclose(OutFile);
  if (retval != 0)
  {
    fprintf(stderr,"flose(\"%s\") failed.\n",buffer);
    exit(-1);
  }
}

void DWriteResult( char *name, double value )
{
  char buffer[256];
  int  retval;
  FILE *OutFile;

  if (DontHaveDir)
  {
    TestEnvVar();
    DontHaveDir = 0;
  }
  sprintf(buffer,"%s/%s",DirName,name);

  OutFile = fopen(buffer,"w");
  if (OutFile == NULL)
  {
    fprintf(stderr,"Cannot open file \"%s\" for output.\n",buffer);
    exit(-1);
  }
  fprintf(OutFile,"%f",value);
  retval = fclose(OutFile);
  if (retval != 0)
  {
    fprintf(stderr,"flose(\"%s\") failed.\n",buffer);
    exit(-1);
  }
}

int ReadResult( char* name )
{
  char buffer[256];
  int i, retval;
  FILE *InFile;

  if (DontHaveDir)
  {
    TestEnvVar();
    DontHaveDir = 0;
  }

  sprintf(buffer,"%s/%s",DirName,name);
  InFile = fopen(buffer,"r");
  if (InFile == NULL)
  {
    fprintf(stderr,"Cannot open file \"%s\" for input.\n",buffer);
    exit(-1);
  }
  retval = fscanf(InFile,"%d",&i);
  if (retval != 1)
  {
    fprintf(stderr,"Format error reading from file \"%s\".\n",buffer);
    exit(-1);
  }
  retval = fclose(InFile);
  if (retval != 0)
  {
    fprintf(stderr,"flose(\"%s\") failed.\n",buffer);
    exit(-1);
  }

  return i;
}

int ReadResultSoft( char* name )  /* returns -1 rather than exiting */
{                                 /* used to indicate failure in the */
  char buffer[256];               /* reconciliation code */
  int i, retval;
  FILE *InFile;

  if (DontHaveDir)
  {
    TestEnvVar();
    DontHaveDir = 0;
  }

  sprintf(buffer,"%s/%s",DirName,name);
  InFile = fopen(buffer,"r");
  if (InFile == NULL)
  {
    return -1;
  }
  retval = fscanf(InFile,"%d",&i);
  if (retval != 1)
  {
    return -1;
  }
  retval = fclose(InFile);
  if (retval != 0)
  {
    return -1;
  }

  return i;
}

double DReadResult( char* name )
{
  char buffer[256];
  double d;
  int retval;
  FILE *InFile;

  if (DontHaveDir)
  {
    TestEnvVar();
    DontHaveDir = 0;
  }

  sprintf(buffer,"%s/%s",DirName,name);
  InFile = fopen(buffer,"r");
  if (InFile == NULL)
  {
    fprintf(stderr,"Cannot open file \"%s\" for input.\n",buffer);
    exit(-1);
  }
  retval = fscanf(InFile,"%lf",&d);
  if (retval != 1)
  {
    fprintf(stderr,"Format error reading from file \"%s\".\n",buffer);
    exit(-1);
  }
  retval = fclose(InFile);
  if (retval != 0)
  {
    fprintf(stderr,"flose(\"%s\") failed.\n",buffer);
    exit(-1);
  }

  return d;
}

double DReadResultSoft( char* name )
{
  char buffer[256];
  double d;
  int retval;
  FILE *InFile;

  if (DontHaveDir)
  {
    TestEnvVar();
    DontHaveDir = 0;
  }

  sprintf(buffer,"%s/%s",DirName,name);
  InFile = fopen(buffer,"r");
  if (InFile == NULL)
  {
    fprintf(stderr,"Cannot open file \"%s\" for input.\n",buffer);
    return -1.0;
  }
  retval = fscanf(InFile,"%lf",&d);
  if (retval != 1)
  {
    fprintf(stderr,"Format error reading from file \"%s\".\n",buffer);
    return -1.0;
  }
  retval = fclose(InFile);
  if (retval != 0)
  {
    fprintf(stderr,"flose(\"%s\") failed.\n",buffer);
    return -1.0;
  }

  return d;
}

int CheckFile( char * name )
{
  char buffer[256];
  int i, retval;
  FILE *InFile;

  if (DontHaveDir)
  {
    TestEnvVar();
    DontHaveDir = 0;
  }
  sprintf(buffer,"%s/%s",DirName,name);
  InFile = fopen(buffer,"r");
  if (InFile == NULL)
    i = -1;  /* return negative one as failure code */

  else
  {
    retval = fscanf(InFile,"%d",&i);
    if (retval != 1)
      i = -2; /* return negative one as failure code */

    retval = fclose(InFile);
    if (retval != 0)
      i = -3;
  }
  return i;
}



int GetL1Size()
{ 
  int i;
  
  return ReadResultSoft("CacheL1Sa");
}

int GetL1LineSize()
{
  return ReadResultSoft("CacheL1Ga");
}

double GetAddCost()
{
  return DReadResultSoft("AddCost");
}
