/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
#include <stdio.h>
#include <stdlib.h>
#include "BlackJackTimer.h"

struct AccessCount 
{ 
  int outer;
  int inner;
};

char *PrintNum( int n );
int  GlobalTrash;

/* TimePerm
 *
 * Runs a permutation and returns elapsed time
 *
 * PARAMETERS: NAccesses
 *
 * RETURNS:    Elapsed time, in microseconds, as a double
 *
 */

double TimePerm( int MemArray[],        /* contains a permutation */
		 int StartPoint,        /* first word in permutation */
		 struct AccessCount NA  /* number of iterations */ )
{
  ticks start, finish;
  int   p, loads, iterations;

  if (NA.outer < 1)
  {
    fprintf(stderr,"In TimePerm(), Access count makes no sense");
    fprintf(stderr," ( %s ; %s )\n",
	    PrintNum(NA.outer), PrintNum(NA.inner));
    Abort("TimePerm() asked to execute zero iterations.\n",-1);
  }

  iterations = NA.outer;

  if ((NA.inner % 10) != 0)
  {
    fprintf(stderr,
	    "TimePerm: Number of iterations (%s)  is not divisible by 10.\n",
	    PrintNum(NA.inner));
  }

  /* start the timer */
  start = getticks();

  while (iterations > 0)
  {
    loads = NA.inner;
    p = StartPoint;

    while (loads > 0)   /* unrolled by ten to reduce loop overhead */
    {
      p = MemArray[p];
      p = MemArray[p];
      p = MemArray[p];
      p = MemArray[p];
      p = MemArray[p];
      p = MemArray[p];
      p = MemArray[p];
      p = MemArray[p];
      p = MemArray[p];
      p = MemArray[p];
      loads -= 10;
    }
    iterations--;
  }
  finish = getticks();

  GlobalTrash = p;

  return elapsed(finish,start);
}
