/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
#include <time.h>
#include <stdio.h>
#include <stdlib.h>

char *CodeBase = "R1 code base (06/2010)";

char *TimeStamp()
{
  time_t    t;
  char *p, *q;

  t = time(NULL);
  q = asctime(localtime(&t));

  /* get rid of the line feed at end of 'q' */
  p = q;
  while(*p != '\0')
  {
    if (*p == '\n')
    {
      *p = '\0';
      break;
    }
    p++;
  }

  return q;
}

/* The top of each log file should begin with a record of 
 * the machine, the date, and the code base.
 *
 */

void SetupAndMark( FILE *f, char *name )
{
  char hn[128];  /* buffer to hold hostname */

  if (f == NULL)
  {
    fprintf(stderr,
	    "SetupAndMark( %s) passed NULL FILE pointer. Run terminates.\n",
	    name);
    (void) exit(-2);
  }

  /* In the event of an abnormal termination, want the file to be unbuffered */
  if (setvbuf(f, NULL, _IONBF, 0) == EOF)
  {
    fprintf(f,"\"%s is buffered.\"\n",name);
    fflush(f);
  }
  else
  {
    fprintf(f,"\"%s is unbuffered.\"\n",name);
  }

  (void) gethostname(hn,128);
  fprintf(f,"\"Run on '%s' at %s using %s.\"\n",hn,TimeStamp(),CodeBase);

}
