/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
/* PACE Project, Rice University
 *
 * Utility routines used in the cache-size tests. 
 *
 */


#include "MemTest.h"
#include "BlackJackTimer.h"

static char errbuf[128];

/* Dealing with Timer Resolution */
/* -- version written for the BlackJack timer */

static int NAdds = 1024*1024;

static double FindOneTick()
{
  double i, adds, clock_time, tick;   /* This version of the code is written */
  ticks start, finish;                /* to work with Anthony Danalis' timer */
  char buffer[24], *p;                /* which returns a number in           */
                                      /* microseconds.                       */
  while(1)
  {
    /* time some workload */
    adds = NAdds;
    i = 0;
  
    start = getticks();
    while(adds > 0.0) 
    {
      i++;
      adds--;
    }

    finish = getticks();
    clock_time = elapsed(finish,start);

    if (clock_time > 1000000)  /* want a time of under 1 second to */
      NAdds = NAdds / 2;       /* simplify the rest of this code   */
    else if (clock_time == 0)
      NAdds = NAdds + NAdds;
    else
    {
      NAdds = NAdds + NAdds/2;
      break;
    }
  }

  GlobalTrash = i;

  /* print it at full precision */
  sprintf(buffer,"%.1f",clock_time);

  p = &buffer[0];      /* find the right end */
  while( *p != '.')    /* the null character */
    p++;

  /* walk from right to left, looking for first non-zero character */
  tick = 1.0;
  p--;
  while(*p == '0') /* the character '0' */
  {
    tick = tick * 10;
    p--;
  }

  return tick;
}

double FindTimerTick()
{
  double tick1, tick2, result;
  int i;

  tick1 = FindOneTick();
  tick2 = FindOneTick();

  if (tick1 < tick2)
    result = tick1;
  else
    result = tick2;

  return result;
}

