/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
/* This version modified to use 'int *' */
#include "MemTest.h"
#include "BlackJackTimer.h"


/* declaration of intrinsic */
double round ( double x );

struct AccessCount NAccesses;

static int StartingPoint     = -1;
static void **MemArray = (void *) NULL;

static int firsttime = 0;

static int AlwaysConfirm( int s )
{
  return 1;
}

/* for use when ArraySize is small relative to BlockSize */
static void BuildRefString( int NSpots, int Gap, int LastOffset )
{
  int i, j, ThisElt, LastElt;
  int Index[NSpots];
  void **p, **Old;

  for (i=0;i<NSpots;i++)
  {
    Index[i] = i * Gap;
  }
  Index[0] += LastOffset;

  if (firsttime)
  {
    fprintf(stderr,"\nIndex set:\n");
    j = 0;
    for (i=0;i<NSpots;i++)
    {
      fprintf(stderr,"%12s ",PrintNum(Index[i]*UnitSize));
      j++;
      if (j == 4)
      {
	fprintf(stderr,"\n");
	j=0;
      }
    }
    fprintf(stderr,"\n\n");
    firsttime--;
  }

  Old = MemArray;
  MemArray = (void **) PACE_AllocMem((NSpots+1)*Gap*UnitSize);
  if (Old != (void **) NULL)
    PACE_FreeMem(Old);

  /* Assemble the permutation ...
   *
   * This case is a degenerate of the more complex, multipage case
   * done below.
   *
   */

  LastElt = -1;
  for (i=0; i<NSpots; i++)
  {
    ThisElt = Index[i];
    if (LastElt != -1)
      MemArray[ThisElt] = &MemArray[LastElt];
    if (Debug>1)
      fprintf(LogFile,"M[%s] <- %s.\n",PrintNum(ThisElt),PrintNum(LastElt));

    LastElt = ThisElt;
  }
  StartingPoint = Index[0];
  MemArray[StartingPoint] = &MemArray[LastElt];

  if (Debug>1)
    fprintf(LogFile,"M[%s] <- %s ** starting point**.\n",
	    PrintNum(StartingPoint),PrintNum(LastElt));

  /* verify permutation */
  p = MemArray[StartingPoint];   
  i = 0;
  while( p != &MemArray[StartingPoint] )
  {
    p = *p;
    i++;
    if (i > NSpots)
    {
      fprintf(stderr,"Cycle did not return to starting point.\n");
      fprintf(stderr,"Cycle length is %s of %s.\n",
	      PrintNum(i),PrintNum(NSpots));
    }
  }
  if (Debug>1)
  {
    if (i == (NSpots-1))
      fprintf(stderr,"Maximal length cycle.\n");
    else 
      fprintf(stderr,"%s vs %s.\n",PrintNum(i),PrintNum(NSpots));
  }


}

/* RunOneTest 
 *
 * RETURNS:     An elapsed time, in microseconds, as a double
 *
 */

static double RunOneTest( int NSpots, int Gap, int Offset )
{
  int i;
  double result;
  
  if (HeartBeat > 1)
    fprintf(stderr,"Trial of %d spots with %s b gap (%s b total size)\n",
	    NSpots,PrintNum(Gap*UnitSize),PrintNum(NSpots*Gap*UnitSize));

  /* Initialize MemArray */
  BuildRefString(NSpots,Gap,Offset);

  /* Run the test */
   result = TimePermPtr(MemArray, StartingPoint, NAccesses);

  if (HeartBeat > 1)
    fprintf(stderr,"%s usec\n",PrintDNum(result));

  return result;
}



/* Find LineSize
 *
 */

void NAFindLineSize( int NSpots, int LevelSize )
{
  int i, j, k, NotDone, series, MoreTests, nPoints;
  int Gap, Count;

  double Trial, CLatency;
  double Times[MAX_TESTS_PER_RUN], Cycles[MAX_TESTS_PER_RUN];
  int Counters[MAX_TESTS_PER_RUN], Offsets[MAX_TESTS_PER_RUN];

  int FirstTime = 1;

  fprintf(LogFile,"\nIn NAFindLineSize.\n");
  fprintf(stderr ,"\nIn NAFindLineSize.\n");

  NAccesses.inner = 1000;
  NAccesses.outer = 1;
  Trial = 0;

  while(Trial < MinTime)
  {
    if (NAccesses.inner < BigInt)
      NAccesses.inner = NAccesses.inner + NAccesses.inner;
    else
      NAccesses.outer = NAccesses.outer + 1;

    Trial = RunOneTest( 2, 2048, 0 );  /* 2 spots at 2 KB, Offset 0 */
  }
  fprintf(LogFile,"Need to run (%s : %s) accesses to achieve > %s usec.\n",
	  PrintNum(NAccesses.outer),PrintNum(NAccesses.inner),
	  PrintNum(MinTime));

  CLatency = Trial * 1000.0 / (double) NAccesses.inner;
  CLatency = CLatency / (double) NAccesses.outer;
  CLatency = round( CLatency / AddCostInNsecs );

  /* Compute the Gap Size */
  Gap = LevelSize / (NSpots - 1);
  MoreTests = 1;

  PageSize = GetOSPageSize() / UnitSize;
  i = 0;
  j = 1;
  fprintf(LogFile,"\nGenerating offsets\n");
  while (j<=PageSize)
  {
    Offsets[i]  = j;
    Counters[i] = TRIALS_FOR_MIN;
    fprintf(LogFile,"%5d ",Offsets[i]);

    i++;
    j *= 2;

    if (i >= MAX_TESTS_PER_RUN)  /* safety valve */
      break;
  }
  Count = i;

  NotDone = 1;
  k = 0;

  while(NotDone)
  {
    NotDone = 0;
    k++;
    for (i=0;i<Count;i++)
    {
      if (Counters[i])
      {
	Trial = RunOneTest(NSpots,Gap,Offsets[i]);
	Counters[i]--;

	if (k = 1)
	  Times[i] = Trial;
	else if (Trial < Times[i])
	{
	  Times[i] = Trial;
	  Counters[i] = TRIALS_FOR_MIN;
	}
	if (Counters[i] > 0)
	  NotDone = 1;

      }
    }
  }

  /* Convert Times to nsecs */
  for (i=0;i<Count;i++)
  {
    Times[i] = Times[i] * 1000.0 / (double) NAccesses.inner ;
    Times[i] = Times[i] / (double) NAccesses.outer;
    Trial = round( Times[i] / AddCostInNsecs );
    Cycles[i] = (int) Trial;
  }

  fprintf(LogFile,"\nGap Linesize Test @ %s b.\n",
	  PrintNum(LevelSize*UnitSize));
  fprintf(LogFile,"%s\tTime\tCycles\n","Offset");
  for (i=0;i<Count;i++)
  {
    fprintf(LogFile,"%3d\t%f\t%.0f\n",Offsets[i],Times[i],Cycles[i]);
  }

  /* Analysis */
  for (i=0l;i<Count;i++)
  {
    if (Cycles[i] == CLatency)
    {
      fprintf(LogFile,"Line size is detected as %3d b.\n",Offsets[i]*UnitSize);
      fprintf(stderr, "Line size is detected as %3d b.\n",Offsets[i]*UnitSize);
      break;
    }
  }

  if (MemArray != (void **) NULL)
  {
    PACE_FreeMem(MemArray);
    MemArray = (void **) NULL;
  }
}



