/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
#include "MemTest.h"
#include "BlackJackTimer.h"

static void **Array = (void**) NULL;

static double NewATest (int ts, int ls, int w, struct AccessCount na );

int AssocTrial ( int ThisLevelSize, int LastLevelSize )
{
  int i, j, nTests, result, MaxWays;
  double Trial;
  struct AccessCount NA; 

  int Ways[32];
  double Times[32];

  if (HeartBeat>1)
    fprintf(stderr,"Associativity Test @ %s b (%s b).\n",
	    PrintNum(ThisLevelSize*UnitSize),PrintNum(LastLevelSize));

  NA.outer = 1;
  NA.inner = 100000;

  Trial = NewATest( ThisLevelSize, LastLevelSize, 2, NA );
  while (Trial < MinTime )
  {
    if (NA.inner < BigInt)
      NA.inner = NA.inner + NA.inner;
    else
      NA.outer++;

    Trial = NewATest( ThisLevelSize, LastLevelSize, 2, NA );
  }
  fprintf(LogFile,
	  "\n\"Associativity test base time for (%s ; %s) accesses is %f.\"\n",
	  PrintNum(NA.outer),PrintNum(NA.inner),Trial);

  MaxWays = Min(32, ThisLevelSize / PageSize);
  fprintf(stderr,"Testing from 1 way to %d ways.\n",MaxWays);
  fprintf(LogFile,"Testing from 1 way to %d ways.\n",MaxWays);

  MaxWays = (MaxWays/2);

  Ways[0] = 1;
  for (i=1;i<=MaxWays;i++)
  {
    Ways[i]  = 2*i;
  }

  nTests = MaxWays;

  for (j=0; j<TRIALS_FOR_MIN; j++)
  {
    for (i=0;i<=MaxWays;i++)
    {
      Trial = NewATest( ThisLevelSize, LastLevelSize, Ways[i], NA );

      if (j==0)
	Times[i] = Trial;
      else if (Trial < Times[i])
	Times[i] = Trial;
    }
  }

  fprintf(LogFile,"Ways\tTime\n");
  for (i=0;i<=MaxWays;i++)
    fprintf(LogFile,"%02d\t%.1f\n",Ways[i],Times[i]);

  result = SharpRiseTest( Ways, Times, MaxWays+1, 0.3 );

  if (result == 0)
  {
    fprintf(stderr,"TLB @ %s b appears to be fully associative.\n",
	    PrintNum(ThisLevelSize*UnitSize));
    fprintf(LogFile,"\"TLB @ %s b appears to be fully associative.\"\n\n",
	    PrintNum(ThisLevelSize*UnitSize));
  }
  else
  {
    fprintf(stderr,"TLB @ %s b has associativity %d.\n",
	    PrintNum(ThisLevelSize*UnitSize),result);
    fprintf(LogFile,"\"TLB @ %s b has associativity %d.\"\n\n",
	    PrintNum(ThisLevelSize*UnitSize),result);
  }
  return result;
}

static double NewATest (int ThisLevelSize,
			int LastLevelSize,
			int Ways, struct AccessCount NA
			)
{
  int i, j, k, l, sp;
  int ThisIndex, LastIndex, ThisLevelPages, LastLevelPages;
  int NLines, PagesPerRow, LeftOvers, NElts,InnerLoopUB;
  int *Index, *Lines;
  void **p;
  double result;

  if (HeartBeat>1 )
    fprintf(stderr,"NewATest( %s b, %s b, %d, (%s : %s):\n",
	    PrintNum(ThisLevelSize*UnitSize),
	    PrintNum(LastLevelSize*UnitSize),
	    Ways,
	    PrintNum(NA.outer),PrintNum(NA.inner));
  if (Debug)
    fprintf(LogFile,"\nNewATest( %s b, %s b, %d, (%s : %s):\n",
	    PrintNum(ThisLevelSize*UnitSize),
	    PrintNum(LastLevelSize*UnitSize),
	    Ways,
	    PrintNum(NA.outer),PrintNum(NA.inner));

  /* First, some checks on parameter values */
  ThisLevelPages = ThisLevelSize / PageSize;
  LastLevelPages = LastLevelSize / PageSize;

  if (Ways > ThisLevelPages)
  {
    fprintf(stderr,
	    "NewATest( %s b ): More ways than pages; ways reset to %d.\n",
	    PrintNum(ThisLevelSize*UnitSize),ThisLevelPages);
    fprintf(LogFile,
	    "NewATest( %s b ): More ways than pages; ways reset to %d.\n",
	    PrintNum(ThisLevelSize*UnitSize),ThisLevelPages);
    Ways = ThisLevelPages;
  }

  /* Build the reference stream */
  /* First, a permuted index of lines in a page */
  NLines = PageSize / L1LineSize;
  Lines = (int*) PACE_AllocMem(NLines * sizeof(int) );
  i = GenerateLinearSet(Lines, NLines, L1LineSize);

  Index = (int*) PACE_AllocMem(2*ThisLevelPages * sizeof(int));

  PagesPerRow = ThisLevelPages / Ways;
  LeftOvers = ThisLevelPages - (PagesPerRow * Ways);
  NElts = PagesPerRow * Ways + LeftOvers;

  if (Debug)
  {
    fprintf(LogFile,"-> %d pages in this level\n",ThisLevelPages);
    fprintf(LogFile,"-> %d pages per row * %d rows + %d left over ( = %d )\n",
	    PagesPerRow,Ways,LeftOvers,NElts);
    if (Ways == 1 || LeftOvers > 0)
      fprintf(LogFile,"\nWays: %d, Leftovers: %d\n",Ways,LeftOvers);
  }

  /* Now, build the permutation */
  k = 0;    /* Modulo counter into the Lines[] set */
  l = 0;    /* Counter used to index the Index[] array */
  for (i=0;i<Ways;i++)
  {
    InnerLoopUB = PagesPerRow;
    if (LeftOvers)
    { 
      InnerLoopUB++;
      LeftOvers--;
    }

    for (j=0;j<InnerLoopUB;j++)
    {
      Index[l] = i * ThisLevelSize + j * PageSize + Lines[k];
      if (Debug>1)
	fprintf(LogFile,
		"%3d; %3d:\t%d x %s + %d x %d + %d\tIndex[%d] <- %s\n",
		i,j,i,PrintNum(ThisLevelSize*UnitSize),j,PageSize,Lines[k],
		l,PrintNum(Index[l]));
      k++;
      if (k > NLines)
	k = 0;
      l++;
    }
  }

  NElts = l;
  if (Debug>1)
    fprintf(LogFile,"Total of %d elements in reference string.\n",NElts);

  if (l != NElts)
    fprintf(stderr,"\nWrong number of generated elements: %d vs %d\n",
	    NElts,l);

  Shuffle( Index, l );

  /* Now, allocate the array and fill it in */
  Array = (void**) PACE_AllocMem( Ways * ThisLevelSize * UnitSize );

  for (i=1;i<NElts;i++)
  {
    Array[Index[i]] = &Array[Index[i-1]];
    if (Debug>1)
      fprintf(LogFile,"\nArray[%d] <- %d",Index[i],Index[i-1]);
  }
  sp = Index[0];  /* starting point for permutation */
  Array[Index[0]] = &Array[Index[NElts-1]];
  if (Debug>1)
    fprintf(LogFile,"\nArray[%d] <- %d\n",Index[0],Index[NElts-1]);

  Flush(ThisLevelSize);

  result = TimePermPtr(Array,sp,NA);

  if (HeartBeat>1)
    fprintf(stderr,"%s usec\n",PrintDNum(result));
 
 PACE_FreeMem(Index);
 PACE_FreeMem(Lines);
 PACE_FreeMem(Array);

 return result;
}
