/*******************************************************************************
 * $HeadURL: svn+ssh://orion.cs.rice.edu/home/jasandov/phd/svn/code/characterization/cache_test/dcache/PACE_timer.h $
 * $Revision: 1880 $
 * $Author: jasandov $
 * $Date: 2010-04-14 08:45:00 -0500 (Wed, 14 Apr 2010) $
 ******************************************************************************/
#ifndef PACE_TIMER_H
#define PACE_TIMER_H

#include <sys/time.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/* PACE clock API */
double PACE_clock() {
  struct timeval cur_time;
  const unsigned int rc = gettimeofday(&cur_time, 0);
  if (rc != 0) {
    perror("error with call to gettimeofday in PACE_clock");
    abort();
  }
  return (double)(cur_time.tv_sec) + (double)(cur_time.tv_usec) / 1000000.0;
}
double PACE_start_clock() {
  return PACE_clock();
}
double PACE_stop_clock() {
  return PACE_clock();
}
#endif /* PACE_TIMER_H */
