/*******************************************************************************
 * $HeadURL: svn+ssh://orion.cs.rice.edu/home/jasandov/phd/svn/code/characterization/cache_test/dcache/dcache.h $
 * $Revision: 1922 $
 * $Author: jasandov $
 * $Date: 2010-05-03 11:06:55 -0500 (Mon, 03 May 2010) $
 ******************************************************************************/
#ifndef DCACHE_UTILS_H
#define DCACHE_UTILS_H

#include <stdio.h>


int filtered_print(double delay);

unsigned int parse_size_string(const char *str, unsigned int *result);

void set_pretty_log_xtics(FILE *out, const unsigned int low_in, const unsigned int high_in);
void set_pretty_lin_xtics(FILE *out, const unsigned int low_in, const unsigned int high_in);

double round_decimal_places(const double x, const unsigned int dp);

const char * pp_size(const double size);

void **malloc_2D_array(unsigned int d1, unsigned int d2, unsigned int element_size);

void free_2D_array(void **array, unsigned int d1, unsigned int d2);

double traverse_list_rel(const unsigned int n, const int data []);

unsigned int traverse_list_rel_until_threshold(const unsigned int min_n, const int data [], const double threshold);

unsigned int traverse_empty_list_rel_until_threshold(const unsigned int min_n, const double threshold);

void link_indices_rel(const unsigned int data_count,
                      int data[],
                      const unsigned int indices_count,
                      const unsigned int indices []);

double traverse_list_abs(const unsigned int n, const void * const data []);

void dump_list_abs(FILE *csv_out, const unsigned int n, const void * const data []);

unsigned int traverse_list_abs_until_threshold(const unsigned int min_n, const void * const data [], const double threshold);

unsigned int traverse_empty_list_abs_until_threshold(const unsigned int min_n, const double threshold);

double traverse_list_abs_with_confidence(const unsigned int n, const void * const data [], const double confidence);


void link_indices_abs(const unsigned int data_count,
                      const void * data[],
                      const unsigned int indices_count,
                      const unsigned int indices []);

void shuffle_indices(const unsigned int indices_count,
                     unsigned int indices []);

void shift_indices_to_zero(const unsigned int indices_count,
                           unsigned int indices []);

void generate_sequential_indices(const unsigned int indices_count,
                                 unsigned int indices []);

void generate_sequential_randomized_indices(const unsigned int indices_count,
                                            unsigned int indices []);

void generate_block_cyclic_indices(const unsigned int indices_count,
                                   unsigned int indices []);

void generate_double_block_cyclic_indices(const unsigned int indices_count,
                                          unsigned int indices []);

void generate_randomized_double_block_cyclic_indices(const unsigned int indices_count,
                                                     unsigned int indices []);


#endif /* DCACHE_UTILS_H */
