#!/bin/sh
################################################################################
# $HeadURL: svn+ssh://orion.cs.rice.edu/home/jasandov/phd/svn/code/characterization/cache_test/dcache/dcache_linesize.sh $
# $Revision: 2031 $
# $Author: jasandov $
# $Date: 2010-06-22 14:35:54 -0500 (Tue, 22 Jun 2010) $
################################################################################
# This script is the driver for the dcache_linesize test; it reads the
# PACE_RCDB file for the cache capacity of each level and then runs an
# individual linesize test for each level
################################################################################
PACE_RCDB=../../../pace_rcdb
#PACE_RCDB=${PACE_RCDB:-./PACE_RCDB}
#
#if [ ! -f "$PACE_RCDB" ]; then
#    echo "Cannot find file PACE_RCDB=\"$PACE_RCDB\""
#    exit -1
#fi

printHeader(){
    echo ""
    echo "********************************************************************************"
    echo "$@"
    echo "********************************************************************************"
}

rm -fr results
mkdir results
cd results


LEVEL=0
DONE=0
while [ $DONE -eq 0 ]; do
    LEVEL=$((LEVEL + 1))
    KEY="cache.kind.data.level.${LEVEL}.total_size"
    CAPACITY=`cat ${PACE_RCDB} | grep "${KEY}" | awk 'END {print $2}'`
    if [ "${CAPACITY}" ]; then
        echo "************************************************************"
        echo "Testing linesize for LEVEL=${LEVEL} CAPCITY=${CAPACITY}"
        echo "************************************************************"
        OUT_LOG="dcache_linesize.L${LEVEL}.out"
        ERR_LOG="dcache_linesize.L${LEVEL}.err"
        run_program 1 ../dcache_linesize "${LEVEL}" "${CAPACITY}" 1>${OUT_LOG} 2>${ERR_LOG}
    else
        DONE=1
    fi
done
