/* Copyright 2011, Rice University.  All rights reserved.
   No warranty of usability express or implied.  Have a lovely day! */
#include <stdio.h>
#include <stdlib.h>

void parse_file(FILE * f, double * timings, unsigned int timings_length) {
  int r;
  int l;
  double d;
  unsigned int num_lines = 0;

  while ((r=fscanf(f, "%d\t%lf\n", &l, &d)) != EOF && num_lines < timings_length) {
    if (r==2) {
      timings[num_lines++] = d;
    } else {
      printf("Error in parse_file: wrong format\n");
      fclose(f);
      free(timings);
      exit(1);
    }
  }
}

int is_inflection_point_fuzzy(double * t, double * last) {
  double prev = *(t - 1);
  double curr = *t;
  double next = *(t + 1);
 
  if (prev > curr &&
      next > curr)
    return 1;

  if (prev > curr &&
      next < curr &&
      next * 1.1 > curr &&
      t + 2 <= last) {
    double nnext = *(t+2);
    if (nnext > curr) return 1;
  }
      
  return 0;
}

void analyse_inflection_points_fuzzy(double* times, unsigned int times_size) {
  int * inflection_pts = (int*)calloc(times_size, sizeof(int));
  int i;
  int ip=0;
  int vec_dist=0;
  int found_period=0;
  int start=0;
  double * final_time_pt = times + times_size - 1;

  /* Find inflection points */
  for(i=1; i < times_size-1; i++) {
    /* Ignore mini inflection points */
    if (times[i-1] > times[i] && times[i] < times[i+1] &&
        times[i]/times[i+1] < 0.9875) {
      fprintf(stderr, "inv_pt: %d\n", i+1);
      inflection_pts[ip]=i+1;
      ++ip;
    } else if (times[i-1] > times[i] && times[i-1] > times[i] * 1.1 &&
               (times[i+1] > 0.95 * times[i] && times[i+1] < 1.05 * times[i]) &&
               times[i] < 0.95 * times[i+2]) {
      fprintf(stderr, "inv_pt (fuzzy): %d\n", i+1);
      inflection_pts[ip]=i+1;
      ++ip;
    }
  }
  vec_dist = inflection_pts[0];
  if (is_inflection_point_fuzzy(times+(vec_dist-1), final_time_pt) && is_inflection_point_fuzzy(times+(2*vec_dist-1), final_time_pt)) {
    printf("<inflection_test_fuzzy><vec_len_awk> %d </vec_len_awk></inflection_test_fuzzy>\n", vec_dist);
    printf("<inflection_test_fuzzy><vec_len>%d</vec_len></inflection_test_fuzzy>\n", vec_dist);
  } else {
    printf("<inflection_test_fuzzy><vec_len_awk> %d </vec_len_awk></inflection_test_fuzzy>\n", 0);
    printf("<inflection_test_fuzzy><vec_len>%d</vec_len></inflection_test_fuzzy>\n", 0);
  }
  /* Confirm first inflection point by looking at the next two inflection points
   */
  /* Only analyse if we found at least 3 inflection points*/
#if 0 
 if (ip>=3) {

    vec_dist = inflection_pts[0];
    int last_inf_pt_at_vec_dist = vec_dist;
    for (i=1; i < ip; ++i) {
      int inf_pt = inflection_pts[i];
      if (inf_pt - last_inf_pt_at_vec_dist == vec_dist) {
        fprintf(stderr, "found period at %d\n", inf_pt);
        last_inf_pt_at_vec_dist = inf_pt;
        ++found_period;
      } else if (inf_pt-3 >= 0) {
        /* Check if the previous point is 'close' and if it could confirm */
        double delta_inf_pt = times[inf_pt-2] - times[inf_pt-1];
        double delta_prev_pt = times[inf_pt-3] - times[inf_pt-2];
        if (delta_inf_pt/delta_prev_pt < 0.20 && delta_prev_pt/delta_inf_pt > 0.0 &&
            inf_pt-1-last_inf_pt_at_vec_dist == vec_dist) {
          fprintf(stderr, "found fuzzy period at %d\n", inf_pt);
          last_inf_pt_at_vec_dist = inf_pt-1;
          ++found_period;
        }
      }
    }

    if (found_period>1) {
      printf("<inflection_test_fuzzy><vec_len debug_period_found=\"%d\">%d</vec_len></inflection_test_fuzzy>\n", found_period, vec_dist);
    }
  }
#endif
   
  free(inflection_pts);
}


int main(int argc, char * argv[]) {
  FILE * f;
  int l;
  int r;
  double d;
  unsigned int num_lines = 0;
  double * timings = NULL;
 
  /* Count lines */
  f = fopen("result.txt", "r");
  while ( (r=fscanf(f, "%d\t%lf\n", &l, &d)) != EOF) {
    num_lines++;
  }
  fclose(f);

  timings = (double*) calloc(num_lines, sizeof(double));  

  /* Parse file */
  f = fopen("result.txt", "r");
  parse_file(f, timings, num_lines);
  fclose(f);
  
  /* Analyse the data */
  analyse_inflection_points_fuzzy(timings, num_lines);

  free(timings);
  return 0;
}
